/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.incendo.cloud.parser;

import gg.mineads.monitor.shadow.annotations.apiguardian.api.API;
import gg.mineads.monitor.shadow.incendo.cloud.context.CommandContext;
import gg.mineads.monitor.shadow.incendo.cloud.context.CommandInput;
import gg.mineads.monitor.shadow.incendo.cloud.parser.ArgumentParseResult;
import gg.mineads.monitor.shadow.incendo.cloud.parser.MappedArgumentParser;
import gg.mineads.monitor.shadow.incendo.cloud.parser.MappedArgumentParserImpl;
import gg.mineads.monitor.shadow.incendo.cloud.parser.ParserDescriptor;
import gg.mineads.monitor.shadow.incendo.cloud.parser.standard.EitherParser;
import gg.mineads.monitor.shadow.incendo.cloud.suggestion.SuggestionProvider;
import gg.mineads.monitor.shadow.incendo.cloud.suggestion.SuggestionProviderHolder;
import gg.mineads.monitor.shadow.incendo.cloud.type.Either;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.NonNull;

@FunctionalInterface
@API(status=API.Status.STABLE)
public interface ArgumentParser<C, T>
extends SuggestionProviderHolder<C> {
    public @NonNull ArgumentParseResult<@NonNull T> parse(@NonNull CommandContext<@NonNull C> var1, @NonNull CommandInput var2);

    @API(status=API.Status.STABLE)
    default public @NonNull CompletableFuture<@NonNull ArgumentParseResult<T>> parseFuture(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        return CompletableFuture.completedFuture(this.parse(commandContext, commandInput));
    }

    @API(status=API.Status.STABLE)
    default public <O> @NonNull FutureArgumentParser<C, O> flatMap(MappedArgumentParser.Mapper<C, T, O> mapper) {
        return new MappedArgumentParserImpl<C, T, O>(this, Objects.requireNonNull(mapper, "mapper"));
    }

    @API(status=API.Status.STABLE)
    default public <O> @NonNull FutureArgumentParser<C, O> flatMapSuccess(@NonNull BiFunction<CommandContext<C>, T, CompletableFuture<ArgumentParseResult<O>>> mapper) {
        Objects.requireNonNull(mapper, "mapper");
        return this.flatMap((ctx, result) -> result.flatMapSuccessFuture(value -> (CompletableFuture)mapper.apply(ctx, value)));
    }

    @API(status=API.Status.STABLE)
    default public <O> @NonNull FutureArgumentParser<C, O> mapSuccess(@NonNull BiFunction<CommandContext<C>, T, CompletableFuture<O>> mapper) {
        Objects.requireNonNull(mapper, "mapper");
        return this.flatMap((ctx, result) -> result.mapSuccessFuture(value -> (CompletableFuture)mapper.apply(ctx, value)));
    }

    @Override
    default public @NonNull SuggestionProvider<C> suggestionProvider() {
        if (this instanceof SuggestionProvider) {
            return (SuggestionProvider)((Object)this);
        }
        return SuggestionProvider.noSuggestions();
    }

    public static <C, U, V> @NonNull ParserDescriptor<C, Either<U, V>> firstOf(@NonNull ParserDescriptor<C, U> primary, @NonNull ParserDescriptor<C, V> fallback) {
        return EitherParser.eitherParser(primary, fallback);
    }

    @FunctionalInterface
    @API(status=API.Status.STABLE)
    public static interface FutureArgumentParser<C, T>
    extends ArgumentParser<C, T> {
        @Override
        default public @NonNull ArgumentParseResult<@NonNull T> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
            throw new UnsupportedOperationException("parse should not be called on a FutureArgumentParser. Call parseFuture instead.");
        }

        @Override
        public @NonNull CompletableFuture<@NonNull ArgumentParseResult<T>> parseFuture(@NonNull CommandContext<C> var1, @NonNull CommandInput var2);
    }
}

