/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.incendo.cloud.translations.minecraft.extras;

import gg.mineads.monitor.shadow.incendo.cloud.minecraft.extras.AudienceProvider;
import gg.mineads.monitor.shadow.incendo.cloud.translations.LocaleExtractor;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class AudienceLocaleExtractor<C>
implements LocaleExtractor<C>,
Function<C, Locale> {
    private final AudienceProvider<C> audienceProvider;
    private final LocaleExtractor<C> fallback;

    private AudienceLocaleExtractor(AudienceProvider<C> audienceProvider, LocaleExtractor<C> fallback) {
        this.audienceProvider = Objects.requireNonNull(audienceProvider, "audienceProvider");
        this.fallback = Objects.requireNonNull(fallback, "fallback");
    }

    public static <C> AudienceLocaleExtractor<C> audienceLocaleExtractor(AudienceProvider<C> audienceProvider) {
        return new AudienceLocaleExtractor<Object>(audienceProvider, $ -> Locale.getDefault());
    }

    public static <C extends Audience> AudienceLocaleExtractor<C> audienceLocaleExtractor() {
        return AudienceLocaleExtractor.audienceLocaleExtractor(AudienceProvider.nativeAudience());
    }

    @Override
    public Locale extract(C recipient) {
        return this.audienceProvider.apply((Object)recipient).get(Identity.LOCALE).orElseGet(() -> this.fallback.extract(recipient));
    }

    @Override
    public @Nullable Locale apply(C recipient) {
        return this.audienceProvider.apply((Object)recipient).get(Identity.LOCALE).orElse(null);
    }

    public AudienceLocaleExtractor<C> defaulted(@NonNull LocaleExtractor<C> fallback) {
        return new AudienceLocaleExtractor<C>(this.audienceProvider, fallback);
    }
}

