/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.incendo.cloud.util;

import gg.mineads.monitor.shadow.annotations.apiguardian.api.API;
import gg.mineads.monitor.shadow.geantyref.GenericTypeReflector;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.INTERNAL)
public final class TypeUtils {
    private TypeUtils() {
    }

    public static String simpleName(@NonNull Type type) {
        String simpleName = GenericTypeReflector.erase(type).getSimpleName();
        if (type instanceof ParameterizedType) {
            String paramTypes = Arrays.stream(((ParameterizedType)type).getActualTypeArguments()).map(TypeUtils::simpleName).collect(Collectors.joining(", "));
            return simpleName + '<' + paramTypes + '>';
        }
        return simpleName;
    }
}

