/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.incendo.cloud.velocity;

import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import gg.mineads.monitor.shadow.incendo.cloud.Command;
import gg.mineads.monitor.shadow.incendo.cloud.brigadier.CloudBrigadierCommand;
import gg.mineads.monitor.shadow.incendo.cloud.brigadier.CloudBrigadierManager;
import gg.mineads.monitor.shadow.incendo.cloud.component.CommandComponent;
import gg.mineads.monitor.shadow.incendo.cloud.internal.CommandRegistrationHandler;
import gg.mineads.monitor.shadow.incendo.cloud.velocity.VelocityCommandManager;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.NonNull;

final class VelocityPluginRegistrationHandler<C>
implements CommandRegistrationHandler<C> {
    private CloudBrigadierManager<C, CommandSource> brigadierManager;
    private VelocityCommandManager<C> manager;

    VelocityPluginRegistrationHandler() {
    }

    void initialize(@NonNull VelocityCommandManager<C> velocityCommandManager) {
        this.manager = velocityCommandManager;
        this.brigadierManager = new CloudBrigadierManager<C, CommandSource>(velocityCommandManager, velocityCommandManager.senderMapper());
    }

    @Override
    public boolean registerCommand(@NonNull Command<C> command) {
        CommandComponent<C> component = command.rootComponent();
        Collection<String> aliases = component.alternativeAliases();
        BrigadierCommand brigadierCommand = new BrigadierCommand(this.brigadierManager.literalBrigadierNodeFactory().createNode(command.rootComponent().name(), command, new CloudBrigadierCommand<C, CommandSource>(this.manager, this.brigadierManager)));
        CommandMeta commandMeta = this.manager.proxyServer().getCommandManager().metaBuilder(brigadierCommand).aliases(aliases.toArray(new String[0])).build();
        aliases.forEach(arg_0 -> ((CommandManager)this.manager.proxyServer().getCommandManager()).unregister(arg_0));
        this.manager.proxyServer().getCommandManager().register(commandMeta, (com.velocitypowered.api.command.Command)brigadierCommand);
        return true;
    }

    @NonNull CloudBrigadierManager<C, CommandSource> brigadierManager() {
        return this.brigadierManager;
    }
}

