/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.configlib;

import gg.mineads.monitor.shadow.configlib.ConfigurationException;
import gg.mineads.monitor.shadow.configlib.Polymorphic;
import gg.mineads.monitor.shadow.configlib.PolymorphicTypes;
import gg.mineads.monitor.shadow.configlib.Reflect;
import gg.mineads.monitor.shadow.configlib.Serializer;
import gg.mineads.monitor.shadow.configlib.SerializerContext;
import gg.mineads.monitor.shadow.configlib.TypeSerializer;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

final class PolymorphicSerializer
implements Serializer<Object, Map<?, ?>> {
    private final SerializerContext context;
    private final Class<?> polymorphicType;
    private final Polymorphic polymorphic;
    private final Map<String, Class<?>> typeByAlias = new HashMap();
    private final Map<Class<?>, String> aliasByType = new HashMap();

    public PolymorphicSerializer(SerializerContext context) {
        this.context = context;
        this.polymorphicType = (Class)context.annotatedType().getType();
        this.polymorphic = this.polymorphicType.getAnnotation(Polymorphic.class);
        this.requireNonBlankProperty();
        this.initAliases();
    }

    private void requireNonBlankProperty() {
        if (gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_L_String.isBlank(this.polymorphic.property())) {
            String msg = PolymorphicSerializer.jvmdowngrader$concat$requireNonBlankProperty$1(J_L_String.formatted("type '%s' uses one.", this.polymorphicType.getName()));
            throw new ConfigurationException(msg);
        }
    }

    private void initAliases() {
        PolymorphicTypes polymorphicTypes = this.polymorphicType.getAnnotation(PolymorphicTypes.class);
        if (polymorphicTypes == null) {
            return;
        }
        for (PolymorphicTypes.Type pType : polymorphicTypes.value()) {
            Class<?> type = pType.type();
            String alias = gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_L_String.isBlank(pType.alias()) ? type.getName() : pType.alias();
            this.requireDistinctAliases(alias);
            this.requireDistinctTypes(type);
            this.typeByAlias.put(alias, type);
            this.aliasByType.put(type, alias);
        }
    }

    private void requireDistinctAliases(String alias) {
        if (this.typeByAlias.containsKey(alias)) {
            String msg = PolymorphicSerializer.jvmdowngrader$concat$requireDistinctAliases$1(J_L_String.formatted("multiple types. Alias '%s' appears more than once.", alias));
            throw new ConfigurationException(msg);
        }
    }

    private void requireDistinctTypes(Class<?> type) {
        if (this.aliasByType.containsKey(type)) {
            String msg = PolymorphicSerializer.jvmdowngrader$concat$requireDistinctTypes$1(J_L_String.formatted("definitions for the same subtype. Type '%s' appears more than once.", type.getName()));
            throw new ConfigurationException(msg);
        }
    }

    @Override
    public Map<?, ?> serialize(Object element) {
        Class<?> elementType = element.getClass();
        TypeSerializer<?, ?> serializer = TypeSerializer.newSerializerFor(elementType, this.context.properties());
        Object serialization = serializer.serialize(element);
        this.requireSerializationNotContainsProperty((Map<?, ?>)serialization);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put(this.polymorphic.property(), this.getTypeIdentifierByType(elementType));
        result.putAll((Map<String, String>)serialization);
        return result;
    }

    private String getTypeIdentifierByType(Class<?> type) {
        String alias = this.aliasByType.get(type);
        return alias == null ? type.getName() : alias;
    }

    private void requireSerializationNotContainsProperty(Map<?, ?> serialization) {
        if (serialization.containsKey(this.polymorphic.property())) {
            String msg = J_L_String.formatted("Polymorphic serialization for type '%s' failed. The type contains a configuration element with name '%s' but that name is used by the @Polymorphic property.", this.polymorphicType.getName(), this.polymorphic.property());
            throw new ConfigurationException(msg);
        }
    }

    @Override
    public Object deserialize(Map<?, ?> element) {
        this.requirePropertyPresent(element);
        Object typeIdentifier = element.get(this.polymorphic.property());
        this.requireTypeIdentifierString(typeIdentifier);
        Class<?> type = this.getTypeByTypeIdentifier((String)typeIdentifier);
        TypeSerializer<?, ?> serializer = TypeSerializer.newSerializerFor(type, this.context.properties());
        return serializer.deserialize(element);
    }

    private Class<?> getTypeByTypeIdentifier(String typeIdentifier) {
        Class<?> type = this.typeByAlias.get(typeIdentifier);
        return type == null ? this.tryFindClass(typeIdentifier) : type;
    }

    private Class<?> tryFindClass(String className) {
        try {
            return Reflect.getClassByName(className);
        }
        catch (RuntimeException e) {
            String msg = J_L_String.formatted("Polymorphic deserialization for type '%s' failed. The class '%s' does not exist.", this.polymorphicType.getName(), className);
            throw new ConfigurationException(msg, e);
        }
    }

    private void requirePropertyPresent(Map<?, ?> element) {
        if (element.get(this.polymorphic.property()) != null) {
            return;
        }
        String msg = J_L_String.formatted("Polymorphic deserialization for type '%s' failed. The property '%s' which holds the type is missing. Value to be deserialized:\n%s", this.polymorphicType.getName(), this.polymorphic.property(), element);
        throw new ConfigurationException(msg);
    }

    private void requireTypeIdentifierString(Object typeIdentifier) {
        if (typeIdentifier instanceof String) {
            return;
        }
        String msg = J_L_String.formatted("Polymorphic deserialization for type '%s' failed. The type identifier '%s' which should hold the type is not a string but of type '%s'.", this.polymorphicType.getName(), typeIdentifier, typeIdentifier.getClass().getName());
        throw new ConfigurationException(msg);
    }

    Class<?> getPolymorphicType() {
        return this.polymorphicType;
    }

    private static /* synthetic */ String jvmdowngrader$concat$requireNonBlankProperty$1(String string) {
        return "The @Polymorphic annotation does not allow a blank property name but " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$requireDistinctAliases$1(String string) {
        return "The @PolymorphicTypes annotation must not use the same alias for " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$requireDistinctTypes$1(String string) {
        return "The @PolymorphicTypes annotation must not contain multiple " + string;
    }
}

