/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.configlib;

import gg.mineads.monitor.shadow.configlib.ConfigurationElement;
import gg.mineads.monitor.shadow.configlib.ConfigurationException;
import gg.mineads.monitor.shadow.configlib.ConfigurationProperties;
import gg.mineads.monitor.shadow.configlib.Reflect;
import gg.mineads.monitor.shadow.configlib.SerializeWith;
import gg.mineads.monitor.shadow.configlib.Serializer;
import gg.mineads.monitor.shadow.configlib.SerializerContext;
import gg.mineads.monitor.shadow.configlib.SerializerContextImpl;
import gg.mineads.monitor.shadow.configlib.Serializers;
import gg.mineads.monitor.shadow.configlib.TypeSerializer;
import gg.mineads.monitor.shadow.configlib.Validator;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Map;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import xyz.wagyourtail.jvmdg.version.Stub;

final class SerializerSelector {
    private static final Map<Class<?>, Serializer<?, ?>> DEFAULT_SERIALIZERS = J_U_Map.ofEntries(J_U_Map.entry(Boolean.TYPE, new Serializers.BooleanSerializer()), J_U_Map.entry(Boolean.class, new Serializers.BooleanSerializer()), J_U_Map.entry(Byte.TYPE, new Serializers.NumberSerializer(Byte.TYPE)), J_U_Map.entry(Byte.class, new Serializers.NumberSerializer(Byte.class)), J_U_Map.entry(Short.TYPE, new Serializers.NumberSerializer(Short.TYPE)), J_U_Map.entry(Short.class, new Serializers.NumberSerializer(Short.class)), J_U_Map.entry(Integer.TYPE, new Serializers.NumberSerializer(Integer.TYPE)), J_U_Map.entry(Integer.class, new Serializers.NumberSerializer(Integer.class)), J_U_Map.entry(Long.TYPE, new Serializers.NumberSerializer(Long.TYPE)), J_U_Map.entry(Long.class, new Serializers.NumberSerializer(Long.class)), J_U_Map.entry(Float.TYPE, new Serializers.NumberSerializer(Float.TYPE)), J_U_Map.entry(Float.class, new Serializers.NumberSerializer(Float.class)), J_U_Map.entry(Double.TYPE, new Serializers.NumberSerializer(Double.TYPE)), J_U_Map.entry(Double.class, new Serializers.NumberSerializer(Double.class)), J_U_Map.entry(Character.TYPE, new Serializers.CharacterSerializer()), J_U_Map.entry(Character.class, new Serializers.CharacterSerializer()), J_U_Map.entry(String.class, new Serializers.StringSerializer()), J_U_Map.entry(BigInteger.class, new Serializers.BigIntegerSerializer()), J_U_Map.entry(BigDecimal.class, new Serializers.BigDecimalSerializer()), J_U_Map.entry(LocalDate.class, new Serializers.LocalDateSerializer()), J_U_Map.entry(LocalTime.class, new Serializers.LocalTimeSerializer()), J_U_Map.entry(LocalDateTime.class, new Serializers.LocalDateTimeSerializer()), J_U_Map.entry(Instant.class, new Serializers.InstantSerializer()), J_U_Map.entry(UUID.class, new Serializers.UuidSerializer()), J_U_Map.entry(File.class, new Serializers.FileSerializer()), J_U_Map.entry(Path.class, new Serializers.PathSerializer()), J_U_Map.entry(URL.class, new Serializers.UrlSerializer()), J_U_Map.entry(URI.class, new Serializers.UriSerializer()));
    private final ConfigurationProperties properties;
    private ConfigurationElement<?> element;
    private int currentNesting = -1;

    public SerializerSelector(ConfigurationProperties properties) {
        this.properties = Validator.requireNonNull(properties, "configuration properties");
    }

    public Serializer<?, ?> select(ConfigurationElement<?> element) {
        this.element = element;
        this.currentNesting = -1;
        return this.selectForType(element.annotatedType());
    }

    private Serializer<?, ?> selectForType(AnnotatedType annotatedType) {
        ++this.currentNesting;
        Serializer<?, ?> custom = this.selectCustomSerializer(annotatedType);
        if (custom != null) {
            return custom;
        }
        Type type = annotatedType.getType();
        if (type instanceof Class) {
            return this.selectForClass(annotatedType);
        }
        if (type instanceof ParameterizedType) {
            return this.selectForParameterizedType((AnnotatedParameterizedType)annotatedType);
        }
        if (type instanceof WildcardType) {
            String msg = SerializerSelector.jvmdowngrader$concat$selectForType$1(this.baseExceptionMessage(type));
            throw new ConfigurationException(msg);
        }
        if (type instanceof GenericArrayType) {
            String msg = SerializerSelector.jvmdowngrader$concat$selectForType$2(this.baseExceptionMessage(type));
            throw new ConfigurationException(msg);
        }
        if (type instanceof TypeVariable) {
            String msg = SerializerSelector.jvmdowngrader$concat$selectForType$3(this.baseExceptionMessage(type));
            throw new ConfigurationException(msg);
        }
        throw new ConfigurationException(this.baseExceptionMessage(type));
    }

    private Serializer<?, ?> selectCustomSerializer(AnnotatedType annotatedType) {
        return SerializerSelector.jvmdg$inlined$or(SerializerSelector.jvmdg$inlined$or(SerializerSelector.jvmdg$inlined$or(SerializerSelector.jvmdg$inlined$or(SerializerSelector.jvmdg$inlined$or(this.findConfigurationElementSerializer(annotatedType), () -> this.findSerializerFactoryForType(annotatedType)), () -> this.findSerializerForType(annotatedType)), () -> this.findSerializerOnType(annotatedType)), () -> this.findMetaSerializerOnType(annotatedType)), () -> this.findSerializerByCondition(annotatedType)).orElse(null);
    }

    private Optional<Serializer<?, ?>> findConfigurationElementSerializer(AnnotatedType annotatedType) {
        SerializeWith annotation = this.element.annotation(SerializeWith.class);
        if (annotation != null && this.currentNesting == annotation.nesting()) {
            return Optional.of(this.newSerializerFromAnnotation(annotatedType, annotation));
        }
        return Optional.empty();
    }

    private Optional<Serializer<?, ?>> findSerializerFactoryForType(AnnotatedType annotatedType) {
        Type type = annotatedType.getType();
        if (type instanceof Class) {
            Class cls = (Class)type;
            if (this.properties.getSerializerFactories().containsKey(cls)) {
                SerializerContextImpl context = new SerializerContextImpl(this.properties, this.element, annotatedType);
                Function<SerializerContext, Serializer<?, ?>> factory = this.properties.getSerializerFactories().get(cls);
                Serializer<?, ?> serializer = factory.apply(context);
                if (serializer == null) {
                    String msg = "Serializer factories must not return null.";
                    throw new ConfigurationException(msg);
                }
                return Optional.of(serializer);
            }
        }
        return Optional.empty();
    }

    private Optional<Serializer<?, ?>> findSerializerForType(AnnotatedType annotatedType) {
        Type type = annotatedType.getType();
        if (type instanceof Class) {
            Class cls = (Class)type;
            if (this.properties.getSerializers().containsKey(cls)) {
                return Optional.of(this.properties.getSerializers().get(cls));
            }
        }
        return Optional.empty();
    }

    private Optional<Serializer<?, ?>> findSerializerOnType(AnnotatedType annotatedType) {
        Class cls;
        Type type = annotatedType.getType();
        if (type instanceof Class && (cls = (Class)type).getDeclaredAnnotation(SerializeWith.class) != null) {
            SerializeWith annotation = cls.getDeclaredAnnotation(SerializeWith.class);
            return Optional.of(this.newSerializerFromAnnotation(annotatedType, annotation));
        }
        return Optional.empty();
    }

    private Optional<Serializer<?, ?>> findMetaSerializerOnType(AnnotatedType annotatedType) {
        Annotation[] annotationArray = annotatedType.getType();
        if (annotationArray instanceof Class) {
            Class cls = (Class)annotationArray;
            for (Annotation meta : cls.getDeclaredAnnotations()) {
                Class<? extends Annotation> metaType = meta.annotationType();
                SerializeWith annotation = metaType.getDeclaredAnnotation(SerializeWith.class);
                if (annotation == null) continue;
                return Optional.of(this.newSerializerFromAnnotation(annotatedType, annotation));
            }
        }
        return Optional.empty();
    }

    private Optional<Serializer<?, ?>> findSerializerByCondition(AnnotatedType annotatedType) {
        for (Map.Entry<Predicate<Type>, Serializer<?, ?>> entry : this.properties.getSerializersByCondition().entrySet()) {
            if (!entry.getKey().test(annotatedType.getType())) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    private Serializer<?, ?> newSerializerFromAnnotation(AnnotatedType annotatedType, SerializeWith annotation) {
        SerializerContextImpl context = new SerializerContextImpl(this.properties, this.element, annotatedType);
        return Serializers.newCustomSerializer(annotation.serializer(), context);
    }

    private Serializer<?, ?> selectForClass(AnnotatedType annotatedType) {
        Class cls = (Class)annotatedType.getType();
        if (DEFAULT_SERIALIZERS.containsKey(cls)) {
            return DEFAULT_SERIALIZERS.get(cls);
        }
        if (Reflect.isEnumType(cls)) {
            Class enumType = cls;
            return new Serializers.EnumSerializer(enumType);
        }
        if (Reflect.isArrayType(cls)) {
            return this.selectForArray((AnnotatedArrayType)annotatedType);
        }
        if (Reflect.isConfigurationType(cls)) {
            return TypeSerializer.newSerializerFor(cls, this.properties);
        }
        String msg = SerializerSelector.jvmdowngrader$concat$selectForClass$1(String.valueOf(cls));
        throw new ConfigurationException(msg);
    }

    private Serializer<?, ?> selectForArray(AnnotatedArrayType annotatedType) {
        AnnotatedType annotatedElementType = annotatedType.getAnnotatedGenericComponentType();
        Class elementType = (Class)annotatedElementType.getType();
        if (elementType == Boolean.TYPE) {
            return new Serializers.PrimitiveBooleanArraySerializer();
        }
        if (elementType == Character.TYPE) {
            return new Serializers.PrimitiveCharacterArraySerializer();
        }
        if (elementType == Byte.TYPE) {
            return new Serializers.PrimitiveByteArraySerializer();
        }
        if (elementType == Short.TYPE) {
            return new Serializers.PrimitiveShortArraySerializer();
        }
        if (elementType == Integer.TYPE) {
            return new Serializers.PrimitiveIntegerArraySerializer();
        }
        if (elementType == Long.TYPE) {
            return new Serializers.PrimitiveLongArraySerializer();
        }
        if (elementType == Float.TYPE) {
            return new Serializers.PrimitiveFloatArraySerializer();
        }
        if (elementType == Double.TYPE) {
            return new Serializers.PrimitiveDoubleArraySerializer();
        }
        Serializer<?, ?> elementSerializer = this.selectForType(annotatedElementType);
        boolean inputNulls = this.properties.inputNulls();
        boolean outputNulls = this.properties.outputNulls();
        return new Serializers.ArraySerializer(elementType, elementSerializer, outputNulls, inputNulls);
    }

    private Serializer<?, ?> selectForParameterizedType(AnnotatedParameterizedType annotatedType) {
        ParameterizedType type = (ParameterizedType)annotatedType.getType();
        Class rawType = (Class)type.getRawType();
        AnnotatedType[] typeArgs = annotatedType.getAnnotatedActualTypeArguments();
        boolean inputNulls = this.properties.inputNulls();
        boolean outputNulls = this.properties.outputNulls();
        if (Reflect.isListType(rawType)) {
            Serializer<?, ?> elementSerializer = this.selectForType(typeArgs[0]);
            return new Serializers.ListSerializer(elementSerializer, outputNulls, inputNulls);
        }
        if (Reflect.isSetType(rawType)) {
            Serializer<?, ?> elementSerializer = this.selectForType(typeArgs[0]);
            return this.properties.serializeSetsAsLists() ? new Serializers.SetAsListSerializer(elementSerializer, outputNulls, inputNulls) : new Serializers.SetSerializer(elementSerializer, outputNulls, inputNulls);
        }
        if (Reflect.isMapType(rawType)) {
            Class cls;
            Type type2 = typeArgs[0].getType();
            if (type2 instanceof Class && (DEFAULT_SERIALIZERS.containsKey(cls = (Class)type2) || Reflect.isEnumType(cls))) {
                Serializer<?, ?> keySerializer = this.selectForClass(typeArgs[0]);
                Serializer<?, ?> valSerializer = this.selectForType(typeArgs[1]);
                return new Serializers.MapSerializer(keySerializer, valSerializer, outputNulls, inputNulls);
            }
            String msg = SerializerSelector.jvmdowngrader$concat$selectForParameterizedType$1(this.baseExceptionMessage(type));
            throw new ConfigurationException(msg);
        }
        String msg = SerializerSelector.jvmdowngrader$concat$selectForParameterizedType$2(this.baseExceptionMessage(type));
        throw new ConfigurationException(msg);
    }

    private String baseExceptionMessage(Type type) {
        return J_L_String.formatted("Cannot select serializer for type '%s'.\n", type);
    }

    private static /* synthetic */ String jvmdowngrader$concat$selectForType$1(String string) {
        return string + "Wildcard types cannot be serialized.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$selectForType$2(String string) {
        return string + "Generic array types cannot be serialized.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$selectForType$3(String string) {
        return string + "Type variables cannot be serialized.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$selectForClass$1(String string) {
        return "Missing serializer for type " + string + ".\nEither annotate the type with @Configuration, make it a Java record, or provide a custom serializer for it.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$selectForParameterizedType$1(String string) {
        return string + "Map keys can only be of simple or enum type.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$selectForParameterizedType$2(String string) {
        return string + "Parameterized types other than lists, sets, and maps cannot be serialized.";
    }

    @Stub
    private static /* synthetic */ <T> Optional<T> jvmdg$inlined$or(Optional<T> optional, Supplier<? extends Optional<? extends T>> supplier) {
        if (optional.isPresent()) {
            return optional;
        }
        Optional<? extends T> result = supplier.get();
        return result;
    }
}

