/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.configlib;

import gg.mineads.monitor.shadow.configlib.ConfigurationElement;
import gg.mineads.monitor.shadow.configlib.ConfigurationElements;
import gg.mineads.monitor.shadow.configlib.ConfigurationException;
import gg.mineads.monitor.shadow.configlib.ConfigurationProperties;
import gg.mineads.monitor.shadow.configlib.ConfigurationSerializer;
import gg.mineads.monitor.shadow.configlib.NameFormatter;
import gg.mineads.monitor.shadow.configlib.PostProcess;
import gg.mineads.monitor.shadow.configlib.RecordSerializer;
import gg.mineads.monitor.shadow.configlib.Reflect;
import gg.mineads.monitor.shadow.configlib.Serializer;
import gg.mineads.monitor.shadow.configlib.SerializerSelector;
import gg.mineads.monitor.shadow.configlib.Validator;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Class;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_R_RecordComponent;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import xyz.wagyourtail.jvmdg.j17.PermittedSubClasses;

@PermittedSubClasses(value={ConfigurationSerializer.class, RecordSerializer.class})
abstract class TypeSerializer<T, E extends ConfigurationElement<?>>
implements Serializer<T, Map<?, ?>> {
    protected final Class<T> type;
    protected final ConfigurationProperties properties;
    protected final NameFormatter formatter;
    protected final Map<String, Serializer<?, ?>> serializers;
    protected final UnaryOperator<T> postProcessor;

    protected TypeSerializer(Class<T> type, ConfigurationProperties properties) {
        this.type = Validator.requireNonNull(type, "type");
        this.properties = Validator.requireNonNull(properties, "configuration properties");
        this.formatter = properties.getNameFormatter();
        this.serializers = this.buildSerializerMap();
        this.postProcessor = this.createPostProcessorFromAnnotatedMethod();
        this.requireSerializableElements();
    }

    static <T> TypeSerializer<T, ?> newSerializerFor(Class<T> type, ConfigurationProperties properties) {
        return J_L_Class.isRecord(type) ? new RecordSerializer<T>(type, properties) : new ConfigurationSerializer<T>(type, properties);
    }

    Map<String, Serializer<?, ?>> buildSerializerMap() {
        SerializerSelector selector = new SerializerSelector(this.properties);
        try {
            return this.elements().stream().collect(Collectors.toMap(ConfigurationElement::name, selector::select));
        }
        catch (StackOverflowError error) {
            String msg = "Recursive type definitions are not supported.";
            throw new ConfigurationException(msg, error);
        }
    }

    @Override
    public final Map<?, ?> serialize(T configuration) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (ConfigurationElement element : this.elements()) {
            Object elementValue = element.value(configuration);
            if (elementValue == null && !this.properties.outputNulls()) continue;
            Object serializedValue = this.serializeElement(element, elementValue);
            String formattedName = this.formatter.format(element.name());
            result.put(formattedName, serializedValue);
        }
        return result;
    }

    protected final Object serializeElement(E element, Object value) {
        if (value == null) {
            return null;
        }
        Serializer<?, ?> serializer = this.serializers.get(element.name());
        try {
            Object serialized = serializer.serialize(value);
            TypeSerializer.validateTargetType(element, value, serialized);
            return serialized;
        }
        catch (ClassCastException e) {
            String msg = J_L_String.formatted("Serialization of value '%s' for element '%s' of type '%s' failed.\nThe type of the object to be serialized does not match the type the custom serializer of type '%s' expects.", value, element.element(), element.declaringType(), serializer.getClass());
            throw new ConfigurationException(msg, e);
        }
    }

    private static void validateTargetType(ConfigurationElement<?> element, Object value, Object serialized) {
        try {
            Validator.requireTargetType(serialized);
        }
        catch (ConfigurationException e) {
            String msg = J_L_String.formatted("Serialization of value '%s' for element '%s' of type '%s' failed. The serializer produced an invalid target type.", value, element.element(), element.declaringType());
            throw new ConfigurationException(msg, e);
        }
    }

    protected final Object deserialize(E element, Object value) {
        Object deserialized;
        Serializer<?, ?> serializer = this.serializers.get(element.name());
        try {
            deserialized = serializer.deserialize(value);
        }
        catch (ClassCastException e) {
            String msg = TypeSerializer.jvmdowngrader$concat$deserialize$1(this.baseDeserializeExceptionMessage(element, value));
            throw new ConfigurationException(msg, e);
        }
        catch (RuntimeException e) {
            String msg = this.baseDeserializeExceptionMessage(element, value);
            throw new ConfigurationException(msg, e);
        }
        return deserialized;
    }

    protected final Object[] deserializeConfigurationElements(Map<?, ?> serializedConfiguration) {
        List<E> elements = this.elements();
        Object[] result = new Object[elements.size()];
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            ConfigurationElement element = (ConfigurationElement)elements.get(i);
            String formattedName = this.formatter.format(element.name());
            if (!serializedConfiguration.containsKey(formattedName)) {
                Object defaultValue = this.getDefaultValueOf(element);
                result[i] = this.applyPostProcessorForElement(element, defaultValue);
                continue;
            }
            Object serializedValue = serializedConfiguration.get(formattedName);
            result[i] = serializedValue == null && this.properties.inputNulls() ? null : (serializedValue == null ? this.getDefaultValueOf(element) : this.deserialize(element, serializedValue));
            result[i] = this.applyPostProcessorForElement(element, result[i]);
        }
        return result;
    }

    private Object applyPostProcessorForElement(ConfigurationElement<?> element, Object deserializeValue) {
        Object result = deserializeValue;
        boolean postProcessed = false;
        for (Map.Entry<Predicate<ConfigurationElement<?>>, UnaryOperator<?>> entry : this.properties.getPostProcessorsByCondition().entrySet()) {
            Predicate<ConfigurationElement<?>> condition = entry.getKey();
            if (!condition.test(element)) continue;
            UnaryOperator<?> postProcessor = entry.getValue();
            result = TypeSerializer.tryApplyPostProcessorForElement(element, postProcessor, result);
            postProcessed = true;
        }
        if (result == null && postProcessed) {
            TypeSerializer.requirePostProcessorDoesNotReturnNullForPrimitiveElement(element);
        } else if (result == null) {
            TypeSerializer.requireNonPrimitiveType(element);
        }
        return result;
    }

    private static Object tryApplyPostProcessorForElement(ConfigurationElement<?> element, UnaryOperator<?> postProcessor, Object value) {
        try {
            UnaryOperator<?> pp = postProcessor;
            return pp.apply(value);
        }
        catch (ClassCastException e) {
            String msg = J_L_String.formatted("Deserialization of value '%s' for element '%s' of type '%s' failed.\nThe type of the object to be deserialized does not match the type post-processor '%s' expects.", value, element.element(), element.declaringType(), postProcessor);
            throw new ConfigurationException(msg, e);
        }
    }

    private static void requirePostProcessorDoesNotReturnNullForPrimitiveElement(ConfigurationElement<?> element) {
        if (!element.type().isPrimitive()) {
            return;
        }
        if (element instanceof ConfigurationElements.RecordComponentElement) {
            ConfigurationElements.RecordComponentElement recordComponentElement = (ConfigurationElements.RecordComponentElement)element;
            J_L_R_RecordComponent component = recordComponentElement.element();
            String msg = J_L_String.formatted("Post-processors must not return null for primitive record components but some post-processor of component '%s' of record type '%s' does.", component, component.getDeclaringRecord());
            throw new ConfigurationException(msg);
        }
        if (element instanceof ConfigurationElements.FieldElement) {
            ConfigurationElements.FieldElement fieldElement = (ConfigurationElements.FieldElement)element;
            Field field = fieldElement.element();
            String msg = J_L_String.formatted("Post-processors must not return null for primitive fields but some post-processor of field '%s' does.", field);
            throw new ConfigurationException(msg);
        }
        throw new ConfigurationException(TypeSerializer.jvmdowngrader$concat$requirePostProcessorDoesNotReturnNullForPrimitiveElement$1(String.valueOf(element)));
    }

    private static void requireNonPrimitiveType(ConfigurationElement<?> element) {
        if (!element.type().isPrimitive()) {
            return;
        }
        if (element instanceof ConfigurationElements.RecordComponentElement) {
            ConfigurationElements.RecordComponentElement recordComponentElement = (ConfigurationElements.RecordComponentElement)element;
            J_L_R_RecordComponent component = recordComponentElement.element();
            String msg = J_L_String.formatted("Cannot set component '%s' of record type '%s' to null. Primitive types cannot be assigned null values.", component, component.getDeclaringRecord());
            throw new ConfigurationException(msg);
        }
        if (element instanceof ConfigurationElements.FieldElement) {
            ConfigurationElements.FieldElement fieldElement = (ConfigurationElements.FieldElement)element;
            Field field = fieldElement.element();
            String msg = J_L_String.formatted("Cannot set field '%s' to null value. Primitive types cannot be assigned null.", field);
            throw new ConfigurationException(msg);
        }
        throw new ConfigurationException(TypeSerializer.jvmdowngrader$concat$requirePostProcessorDoesNotReturnNullForPrimitiveElement$1(String.valueOf(element)));
    }

    final UnaryOperator<T> createPostProcessorFromAnnotatedMethod() {
        List<Method> list = J_U_S_Stream.toList(Arrays.stream(this.type.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(PostProcess.class)).filter((Method::isSynthetic).negate()).filter((this::isAccessorMethod).negate()));
        if (list.isEmpty()) {
            return UnaryOperator.identity();
        }
        if (list.size() > 1) {
            String methodNames = String.join((CharSequence)"\n  ", J_U_S_Stream.toList(list.stream().map(Method::toString)));
            String msg = TypeSerializer.jvmdowngrader$concat$createPostProcessorFromAnnotatedMethod$1(J_L_String.formatted("post-processing but type '%s' defines %d:\n  %s", this.type, list.size(), methodNames));
            throw new ConfigurationException(msg);
        }
        Method method2 = list.get(0);
        int modifiers = method2.getModifiers();
        if (Modifier.isAbstract(modifiers) || Modifier.isStatic(modifiers)) {
            String msg = TypeSerializer.jvmdowngrader$concat$createPostProcessorFromAnnotatedMethod$2(J_L_String.formatted("but post-processing method '%s' of type '%s' is.", method2, this.type));
            throw new ConfigurationException(msg);
        }
        int parameterCount = method2.getParameterCount();
        if (parameterCount > 0) {
            String msg = TypeSerializer.jvmdowngrader$concat$createPostProcessorFromAnnotatedMethod$3(J_L_String.formatted("post-processing method '%s' of type '%s' defines %d.", method2, this.type, parameterCount));
            throw new ConfigurationException(msg);
        }
        Class<?> returnType = method2.getReturnType();
        if (returnType != Void.TYPE && returnType != this.type) {
            String msg = TypeSerializer.jvmdowngrader$concat$createPostProcessorFromAnnotatedMethod$4(J_L_String.formatted("type '%s' is neither 'void' nor '%s'.", this.type, this.type.getSimpleName()));
            throw new ConfigurationException(msg);
        }
        return object -> {
            if (method2.getReturnType() == Void.TYPE) {
                Reflect.invoke(method2, object, new Object[0]);
                return object;
            }
            Object result = Reflect.invoke(method2, object, new Object[0]);
            return result;
        };
    }

    final boolean isAccessorMethod(Method method) {
        if (!J_L_Class.isRecord(this.type)) {
            return false;
        }
        if (!method.getDeclaringClass().equals(this.type)) {
            return false;
        }
        if (method.getParameterCount() > 0) {
            return false;
        }
        return Arrays.stream(J_L_Class.getRecordComponents(this.type)).map(J_L_R_RecordComponent::getName).anyMatch(s -> s.equals(method.getName()));
    }

    protected abstract void requireSerializableElements();

    protected abstract String baseDeserializeExceptionMessage(E var1, Object var2);

    protected abstract List<E> elements();

    protected abstract Object getDefaultValueOf(E var1);

    abstract T newDefaultInstance();

    private static /* synthetic */ String jvmdowngrader$concat$deserialize$1(String string) {
        return string + "\nThe type of the object to be deserialized does not match the type the deserializer expects.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$requirePostProcessorDoesNotReturnNullForPrimitiveElement$1(String string) {
        return "Unhandled ConfigurationElement: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$createPostProcessorFromAnnotatedMethod$1(String string) {
        return "Configuration types must not define more than one method for " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$createPostProcessorFromAnnotatedMethod$2(String string) {
        return "Post-processing methods must be neither abstract nor static, " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$createPostProcessorFromAnnotatedMethod$3(String string) {
        return "Post-processing methods must not define any parameters but " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$createPostProcessorFromAnnotatedMethod$4(String string) {
        return "The return type of post-processing methods must either be 'void' or the same type as the configuration type in which the post-processing method is defined. The return type of the post-processing method of " + string;
    }
}

