/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.incendo.cloud.minecraft.extras.caption;

import gg.mineads.monitor.shadow.annotations.apiguardian.api.API;
import gg.mineads.monitor.shadow.incendo.cloud.caption.Caption;
import gg.mineads.monitor.shadow.incendo.cloud.caption.CaptionVariable;
import gg.mineads.monitor.shadow.incendo.cloud.minecraft.extras.caption.ComponentCaptionFormatter;
import gg.mineads.monitor.shadow.incendo.cloud.minecraft.extras.caption.RichVariable;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.INTERNAL)
final class MiniMessageComponentCaptionFormatter<C>
implements ComponentCaptionFormatter<C> {
    private final MiniMessage miniMessage;
    private final List<TagResolver> extraResolvers;

    MiniMessageComponentCaptionFormatter(@NonNull MiniMessage miniMessage, @NonNull List<TagResolver> extraResolvers) {
        this.miniMessage = miniMessage;
        this.extraResolvers = extraResolvers;
    }

    @Override
    public @NonNull Component formatCaption(@NonNull Caption captionKey, @NonNull C recipient, @NonNull String caption, @NonNull List<@NonNull CaptionVariable> variables) {
        TagResolver.Builder builder = TagResolver.builder();
        builder.resolvers(this.extraResolvers);
        for (CaptionVariable variable : variables) {
            String key = variable.key();
            if (variable instanceof RichVariable) {
                builder.resolver(Placeholder.component(key, ((RichVariable)variable).component()));
                continue;
            }
            builder.resolver(Placeholder.parsed(key, variable.value()));
        }
        return this.miniMessage.deserialize(caption, builder.build());
    }
}

