/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.incendo.cloud.translations;

import gg.mineads.monitor.shadow.geantyref.GenericTypeReflector;
import gg.mineads.monitor.shadow.geantyref.TypeToken;
import gg.mineads.monitor.shadow.incendo.cloud.translations.LocaleExtractor;
import gg.mineads.monitor.shadow.incendo.cloud.type.tuple.Pair;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j10.stub.java_base.J_U_List;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class LocaleExtractorBuilderImpl<C>
implements LocaleExtractor.Builder<C> {
    private @NonNull LocaleExtractor<C> fallback = $ -> Locale.getDefault();
    private final LinkedList<Pair<Type, Function<Object, @Nullable Locale>>> extractors = new LinkedList();

    LocaleExtractorBuilderImpl() {
    }

    @Override
    public @NonNull LocaleExtractor.Builder<C> fallback(@NonNull LocaleExtractor<C> fallback) {
        this.fallback = Objects.requireNonNull(fallback);
        return this;
    }

    @Override
    public <S extends C> @NonNull LocaleExtractor.Builder<C> senderType(@NonNull TypeToken<S> senderType, @NonNull Function<S, @Nullable Locale> extractor) {
        this.extractors.addFirst(Pair.of(senderType.getType(), extractor));
        return this;
    }

    @Override
    public @NonNull LocaleExtractor<C> build() {
        LocaleExtractor fallback = this.fallback;
        List<Pair<Type, Function<Object, Locale>>> extractors = J_U_List.copyOf(this.extractors);
        return recipient -> {
            for (Pair pair : extractors) {
                Locale apply;
                if (!GenericTypeReflector.isSuperType((Type)pair.first(), recipient.getClass()) || (apply = (Locale)((Function)pair.second()).apply(recipient)) == null) continue;
                return apply;
            }
            return fallback.extract(recipient);
        };
    }
}

