/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.incendo.cloud.translations;

import gg.mineads.monitor.shadow.annotations.apiguardian.api.API;
import gg.mineads.monitor.shadow.incendo.cloud.caption.Caption;
import gg.mineads.monitor.shadow.incendo.cloud.translations.TranslatedCaptionProvider;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(status=API.Status.INTERNAL)
final class ResourceBundleTranslatedCaptionProvider<C>
implements TranslatedCaptionProvider<C> {
    private final ResourceBundle resourceBundle;
    private final Locale locale;

    ResourceBundleTranslatedCaptionProvider(@NonNull ResourceBundle resourceBundle, @NonNull Locale locale) {
        this.resourceBundle = Objects.requireNonNull(resourceBundle, "resourceBundle");
        this.locale = Objects.requireNonNull(locale, "locale");
    }

    @Override
    public boolean isEmpty() {
        return this.resourceBundle.keySet().isEmpty();
    }

    @Override
    public @NonNull Locale locale() {
        return this.locale;
    }

    @Override
    public @Nullable String provide(@NonNull Caption caption, @NonNull C recipient) {
        if (this.resourceBundle.containsKey(caption.key())) {
            return this.resourceBundle.getString(caption.key());
        }
        return null;
    }
}

