/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shared.command;

import gg.mineads.monitor.data.BuildData;
import gg.mineads.monitor.shadow.incendo.cloud.CommandManager;
import gg.mineads.monitor.shadow.incendo.cloud.annotation.specifier.Greedy;
import gg.mineads.monitor.shadow.incendo.cloud.annotations.Argument;
import gg.mineads.monitor.shadow.incendo.cloud.annotations.Command;
import gg.mineads.monitor.shadow.incendo.cloud.annotations.CommandDescription;
import gg.mineads.monitor.shadow.incendo.cloud.annotations.Permission;
import gg.mineads.monitor.shadow.incendo.cloud.annotations.suggestion.Suggestions;
import gg.mineads.monitor.shadow.incendo.cloud.context.CommandContext;
import gg.mineads.monitor.shadow.incendo.cloud.help.result.CommandEntry;
import gg.mineads.monitor.shadow.incendo.cloud.minecraft.extras.MinecraftHelp;
import gg.mineads.monitor.shadow.incendo.cloud.minecraft.extras.caption.ComponentCaptionFormatter;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import gg.mineads.monitor.shared.ComponentHelper;
import gg.mineads.monitor.shared.MineAdsMonitorPlugin;
import gg.mineads.monitor.shared.command.sender.WrappedCommandSender;
import gg.mineads.monitor.shared.event.TypeUtil;
import gg.mineads.monitor.shared.event.generated.EventType;
import gg.mineads.monitor.shared.event.generated.MineAdsEvent;
import gg.mineads.monitor.shared.event.generated.TransactionData;
import java.util.List;
import java.util.logging.Logger;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

@Command(value="mineadsmonitor")
@Permission(value={"mineadsmonitor.admin"})
public class MineAdsCommand {
    @Generated
    private static final Logger log = Logger.getLogger(MineAdsCommand.class.getName());
    private final MineAdsMonitorPlugin plugin;
    private final CommandManager<WrappedCommandSender> commandManager;

    @Command(value="")
    @CommandDescription(value="Displays help information for MineAds Monitor commands")
    public void rootCommand(WrappedCommandSender sender) {
        MinecraftHelp.builder().commandManager(this.commandManager).audienceProvider(ComponentHelper::commandSenderToAudience).commandPrefix("/mineadsmonitor help").messageProvider(MinecraftHelp.captionMessageProvider(this.commandManager.captionRegistry(), ComponentCaptionFormatter.miniMessage())).descriptionDecorator(MinecraftHelp.DescriptionDecorator.text()).commandFilter(c -> c.rootComponent().name().equals("mineadsmonitor") && !c.commandDescription().description().isEmpty()).maxResultsPerPage(Integer.MAX_VALUE).build().queryCommands("", sender);
    }

    @Suggestions(value="help_queries_mineadsmonitor")
    public List<String> suggestHelpQueries(CommandContext<WrappedCommandSender> ctx, String input) {
        return J_U_S_Stream.toList(this.commandManager.createHelpHandler().queryRootIndex(ctx.sender()).entries().stream().filter(e -> e.command().rootComponent().name().equals("mineadsmonitor")).map(CommandEntry::syntax));
    }

    @Command(value="help [query]")
    @CommandDescription(value="Displays help information for MineAds Monitor commands")
    public void commandHelp(WrappedCommandSender sender, @Argument(suggestions="help_queries_mineadsmonitor") @Greedy String query) {
        MinecraftHelp.builder().commandManager(this.commandManager).audienceProvider(ComponentHelper::commandSenderToAudience).commandPrefix("/mineadsmonitor help").messageProvider(MinecraftHelp.captionMessageProvider(this.commandManager.captionRegistry(), ComponentCaptionFormatter.miniMessage())).descriptionDecorator(MinecraftHelp.DescriptionDecorator.text()).commandFilter(c -> c.rootComponent().name().equals("mineadsmonitor") && !c.commandDescription().description().isEmpty()).build().queryCommands(query == null ? "" : query, sender);
    }

    @Command(value="version")
    @CommandDescription(value="Displays the current version of MineAds Monitor")
    public void onVersion(WrappedCommandSender sender) {
        if (this.plugin.getConfig().isDebug()) {
            log.info("[DEBUG] Version command executed");
        }
        sender.sendMessage(Component.text(MineAdsCommand.jvmdowngrader$concat$onVersion$1(BuildData.VERSION), (TextColor)NamedTextColor.GREEN));
    }

    @Command(value="reload")
    @CommandDescription(value="Reloads the MineAds Monitor configuration")
    public void onReload(WrappedCommandSender sender) {
        if (this.plugin.getConfig().isDebug()) {
            log.info("[DEBUG] Reload command executed");
        }
        sender.sendMessage(Component.text("Reloading MineAds Monitor configuration...", (TextColor)NamedTextColor.YELLOW));
        boolean success = this.plugin.reloadConfig();
        if (success) {
            sender.sendMessage(Component.text("Configuration reloaded successfully!", (TextColor)NamedTextColor.GREEN));
            if (this.plugin.getConfig().isDebug()) {
                log.info("[DEBUG] Configuration reloaded successfully");
            }
        } else {
            sender.sendMessage(Component.text("Failed to reload configuration. Check console for details.", (TextColor)NamedTextColor.RED));
            if (this.plugin.getConfig().isDebug()) {
                log.info("[DEBUG] Configuration reload failed");
            }
        }
    }

    @Command(value="initial <transactionId> <username> <uuid> <packageName> <price> <currency>")
    @CommandDescription(value="Records an initial purchase event")
    public void onInitial(WrappedCommandSender sender, @Argument(value="transactionId") String transactionId, @Argument(value="username") String username, @Argument(value="uuid") String uuid, @Argument(value="packageName") String packageName, @Argument(value="price") double price, @Argument(value="currency") String currency) {
        TransactionData transactionData = TransactionData.newBuilder().setTransactionId(transactionId).setUsername(username).setUuid(uuid).setPackageName(packageName).setPrice(price).setCurrency(currency).build();
        MineAdsEvent transactionEvent = TypeUtil.createTransactionEvent(transactionData, EventType.INITIAL);
        if (this.plugin.isInitialized() && this.plugin.getBatchProcessor() != null) {
            this.plugin.getBatchProcessor().addEvent(transactionEvent);
            sender.sendMessage(Component.text("Initial purchase event recorded successfully", (TextColor)NamedTextColor.GREEN));
            if (this.plugin.getConfig().isDebug()) {
                log.info(MineAdsCommand.jvmdowngrader$concat$onInitial$1(username, packageName, transactionId));
            }
        } else {
            sender.sendMessage(Component.text("Plugin not properly initialized - check plugin configuration", (TextColor)NamedTextColor.RED));
            if (this.plugin.getConfig().isDebug()) {
                log.info("[DEBUG] Failed to record initial purchase - plugin not initialized");
            }
        }
    }

    @Command(value="expiry <transactionId> <username> <uuid> <packageName> <price> <currency>")
    @CommandDescription(value="Records an expiry event")
    public void onExpiry(WrappedCommandSender sender, @Argument(value="transactionId") String transactionId, @Argument(value="username") String username, @Argument(value="uuid") String uuid, @Argument(value="packageName") String packageName, @Argument(value="price") double price, @Argument(value="currency") String currency) {
        TransactionData transactionData = TransactionData.newBuilder().setTransactionId(transactionId).setUsername(username).setUuid(uuid).setPackageName(packageName).setPrice(price).setCurrency(currency).build();
        MineAdsEvent transactionEvent = TypeUtil.createTransactionEvent(transactionData, EventType.EXPIRY);
        if (this.plugin.isInitialized() && this.plugin.getBatchProcessor() != null) {
            this.plugin.getBatchProcessor().addEvent(transactionEvent);
            sender.sendMessage(Component.text("Expiry event recorded successfully", (TextColor)NamedTextColor.GREEN));
            if (this.plugin.getConfig().isDebug()) {
                log.info(MineAdsCommand.jvmdowngrader$concat$onExpiry$1(username, packageName, transactionId));
            }
        } else {
            sender.sendMessage(Component.text("Plugin not properly initialized - check plugin configuration", (TextColor)NamedTextColor.RED));
            if (this.plugin.getConfig().isDebug()) {
                log.info("[DEBUG] Failed to record expiry - plugin not initialized");
            }
        }
    }

    @Command(value="renewal <transactionId> <username> <uuid> <packageName> <price> <currency>")
    @CommandDescription(value="Records a renewal event")
    public void onRenewal(WrappedCommandSender sender, @Argument(value="transactionId") String transactionId, @Argument(value="username") String username, @Argument(value="uuid") String uuid, @Argument(value="packageName") String packageName, @Argument(value="price") double price, @Argument(value="currency") String currency) {
        TransactionData transactionData = TransactionData.newBuilder().setTransactionId(transactionId).setUsername(username).setUuid(uuid).setPackageName(packageName).setPrice(price).setCurrency(currency).build();
        MineAdsEvent transactionEvent = TypeUtil.createTransactionEvent(transactionData, EventType.RENEWAL);
        if (this.plugin.isInitialized() && this.plugin.getBatchProcessor() != null) {
            this.plugin.getBatchProcessor().addEvent(transactionEvent);
            sender.sendMessage(Component.text("Renewal event recorded successfully", (TextColor)NamedTextColor.GREEN));
            if (this.plugin.getConfig().isDebug()) {
                log.info(MineAdsCommand.jvmdowngrader$concat$onRenewal$1(username, packageName, transactionId));
            }
        } else {
            sender.sendMessage(Component.text("Plugin not properly initialized - check plugin configuration", (TextColor)NamedTextColor.RED));
            if (this.plugin.getConfig().isDebug()) {
                log.info("[DEBUG] Failed to record renewal - plugin not initialized");
            }
        }
    }

    @Command(value="chargeback <transactionId> <username> <uuid> <packageName> <price> <currency>")
    @CommandDescription(value="Records a chargeback event")
    public void onChargeback(WrappedCommandSender sender, @Argument(value="transactionId") String transactionId, @Argument(value="username") String username, @Argument(value="uuid") String uuid, @Argument(value="packageName") String packageName, @Argument(value="price") double price, @Argument(value="currency") String currency) {
        TransactionData transactionData = TransactionData.newBuilder().setTransactionId(transactionId).setUsername(username).setUuid(uuid).setPackageName(packageName).setPrice(price).setCurrency(currency).build();
        MineAdsEvent transactionEvent = TypeUtil.createTransactionEvent(transactionData, EventType.CHARGEBACK);
        if (this.plugin.isInitialized() && this.plugin.getBatchProcessor() != null) {
            this.plugin.getBatchProcessor().addEvent(transactionEvent);
            sender.sendMessage(Component.text("Chargeback event recorded successfully", (TextColor)NamedTextColor.GREEN));
            if (this.plugin.getConfig().isDebug()) {
                log.info(MineAdsCommand.jvmdowngrader$concat$onChargeback$1(username, packageName, transactionId));
            }
        } else {
            sender.sendMessage(Component.text("Plugin not properly initialized - check plugin configuration", (TextColor)NamedTextColor.RED));
            if (this.plugin.getConfig().isDebug()) {
                log.info("[DEBUG] Failed to record chargeback - plugin not initialized");
            }
        }
    }

    @Command(value="refund <transactionId> <username> <uuid> <packageName> <price> <currency>")
    @CommandDescription(value="Records a refund event")
    public void onRefund(WrappedCommandSender sender, @Argument(value="transactionId") String transactionId, @Argument(value="username") String username, @Argument(value="uuid") String uuid, @Argument(value="packageName") String packageName, @Argument(value="price") double price, @Argument(value="currency") String currency) {
        TransactionData transactionData = TransactionData.newBuilder().setTransactionId(transactionId).setUsername(username).setUuid(uuid).setPackageName(packageName).setPrice(price).setCurrency(currency).build();
        MineAdsEvent transactionEvent = TypeUtil.createTransactionEvent(transactionData, EventType.REFUND);
        if (this.plugin.isInitialized() && this.plugin.getBatchProcessor() != null) {
            this.plugin.getBatchProcessor().addEvent(transactionEvent);
            sender.sendMessage(Component.text("Refund event recorded successfully", (TextColor)NamedTextColor.GREEN));
            if (this.plugin.getConfig().isDebug()) {
                log.info(MineAdsCommand.jvmdowngrader$concat$onRefund$1(username, packageName, transactionId));
            }
        } else {
            sender.sendMessage(Component.text("Plugin not properly initialized - check plugin configuration", (TextColor)NamedTextColor.RED));
            if (this.plugin.getConfig().isDebug()) {
                log.info("[DEBUG] Failed to record refund - plugin not initialized");
            }
        }
    }

    @Generated
    public MineAdsCommand(MineAdsMonitorPlugin plugin, CommandManager<WrappedCommandSender> commandManager) {
        this.plugin = plugin;
        this.commandManager = commandManager;
    }

    private static /* synthetic */ String jvmdowngrader$concat$onVersion$1(String string) {
        return "Current plugin version: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$onInitial$1(String string, String string2, String string3) {
        return "[DEBUG] Initial purchase event recorded for player: " + string + ", package: " + string2 + ", transaction: " + string3;
    }

    private static /* synthetic */ String jvmdowngrader$concat$onExpiry$1(String string, String string2, String string3) {
        return "[DEBUG] Expiry event recorded for player: " + string + ", package: " + string2 + ", transaction: " + string3;
    }

    private static /* synthetic */ String jvmdowngrader$concat$onRenewal$1(String string, String string2, String string3) {
        return "[DEBUG] Renewal event recorded for player: " + string + ", package: " + string2 + ", transaction: " + string3;
    }

    private static /* synthetic */ String jvmdowngrader$concat$onChargeback$1(String string, String string2, String string3) {
        return "[DEBUG] Chargeback event recorded for player: " + string + ", package: " + string2 + ", transaction: " + string3;
    }

    private static /* synthetic */ String jvmdowngrader$concat$onRefund$1(String string, String string2, String string3) {
        return "[DEBUG] Refund event recorded for player: " + string + ", package: " + string2 + ", transaction: " + string3;
    }
}

