/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shared.event;

import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_L_String;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpClient;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpRequest;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpResponse;
import gg.mineads.monitor.shared.MineAdsMonitorPlugin;
import gg.mineads.monitor.shared.config.Config;
import gg.mineads.monitor.shared.event.generated.EventBatch;
import gg.mineads.monitor.shared.event.generated.MineAdsEvent;
import gg.mineads.monitor.shared.scheduler.MineAdsScheduler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import lombok.Generated;
import xyz.wagyourtail.jvmdg.version.Stub;

public class BatchProcessor
implements Runnable {
    @Generated
    private static final Logger log = Logger.getLogger(BatchProcessor.class.getName());
    private static final int BATCH_SIZE_THRESHOLD = 100;
    private static final int MAX_RETRY_ATTEMPTS = 3;
    private static final long INITIAL_RETRY_DELAY_MS = 1000L;
    private static final long MAX_RETRY_DELAY_MS = 30000L;
    private static final Duration REQUEST_TIMEOUT = Duration.ofSeconds(30L);
    private final Queue<MineAdsEvent> events = new ConcurrentLinkedQueue<MineAdsEvent>();
    private final MineAdsMonitorPlugin plugin;
    private final MineAdsScheduler scheduler;
    private final J_N_H_HttpClient httpClient = J_N_H_HttpClient.newBuilder().version(J_N_H_HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(10L)).build();
    private final ReentrantLock processingLock = new ReentrantLock();
    private final AtomicBoolean isProcessing = new AtomicBoolean(false);

    private byte[] serializeToProtobuf(Queue<MineAdsEvent> events) {
        Config config = this.plugin.getConfig();
        return BatchProcessor.compress(EventBatch.newBuilder().addAllEvents(events).setServerId(config.getServerId()).build().toByteArray());
    }

    @Override
    public void run() {
        if (this.plugin.hasConfigIssues()) {
            if (this.plugin.getConfig().isDebug()) {
                log.info("[DEBUG] Skipping batch processing due to configuration issues");
            }
            return;
        }
        Config config = this.plugin.getConfig();
        if (config != null && config.isDebug()) {
            log.info(BatchProcessor.jvmdowngrader$concat$run$1(this.events.size()));
        }
        if (!this.events.isEmpty()) {
            this.processQueueAsync();
        }
    }

    private void processQueueAsync() {
        Config config = this.plugin.getConfig();
        if (!this.processingLock.tryLock()) {
            if (config != null && config.isDebug()) {
                log.info("[DEBUG] Another thread is already processing batch, skipping");
            }
            return;
        }
        try {
            if (this.isProcessing.getAndSet(true)) {
                if (config != null && config.isDebug()) {
                    log.info("[DEBUG] Batch processing already in progress, skipping");
                }
                return;
            }
            if (config != null && config.isDebug()) {
                log.info("[DEBUG] Starting async batch processing");
            }
            CompletableFuture.runAsync(this::processQueueSafely).whenComplete((result, throwable) -> {
                this.isProcessing.set(false);
                if (throwable != null) {
                    log.severe(BatchProcessor.jvmdowngrader$concat$lambda$processQueueAsync$0$1(throwable.getMessage()));
                }
            });
        }
        finally {
            this.processingLock.unlock();
        }
    }

    public void processIfNecessary() {
        if (this.events.size() >= 100 && !this.isProcessing.get()) {
            this.processQueueAsync();
        }
    }

    public void addEvent(MineAdsEvent event) {
        this.events.add(event);
        Config config = this.plugin.getConfig();
        if (config != null && config.isDebug()) {
            log.info(BatchProcessor.jvmdowngrader$concat$addEvent$1(this.events.size()));
        }
        this.processIfNecessary();
    }

    void processQueueSafely() {
        block7: {
            ConcurrentLinkedQueue<MineAdsEvent> currentEvents = new ConcurrentLinkedQueue<MineAdsEvent>();
            int drained = 0;
            while (!this.events.isEmpty() && drained < 100) {
                MineAdsEvent event2 = this.events.poll();
                if (event2 == null) continue;
                currentEvents.add(event2);
                ++drained;
            }
            Config config = this.plugin.getConfig();
            if (currentEvents.isEmpty()) {
                if (config != null && config.isDebug()) {
                    log.info("[DEBUG] No events to process");
                }
                return;
            }
            if (config != null && config.isDebug()) {
                log.info(BatchProcessor.jvmdowngrader$concat$processQueueSafely$1(drained));
                Map<String, Long> eventTypes = currentEvents.stream().collect(Collectors.groupingBy(event -> event.getEventType().name(), Collectors.counting()));
                log.info(BatchProcessor.jvmdowngrader$concat$processQueueSafely$1(String.valueOf(eventTypes)));
            }
            try {
                byte[] protobuf = this.serializeToProtobuf(currentEvents);
                if (config != null && config.isDebug()) {
                    log.info(BatchProcessor.jvmdowngrader$concat$processQueueSafely$2(protobuf.length));
                }
                this.sendBatchWithRetry(protobuf, 0);
            }
            catch (Exception e) {
                log.severe(BatchProcessor.jvmdowngrader$concat$processQueueSafely$2(e.getMessage()));
                this.events.addAll(currentEvents);
                if (config == null || !config.isDebug()) break block7;
                log.info(BatchProcessor.jvmdowngrader$concat$processQueueSafely$3(currentEvents.size()));
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] compress(byte[] data) {
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream(data.length);){
            byte[] byArray;
            try (GZIPOutputStream gzipStream = new GZIPOutputStream(byteStream);){
                gzipStream.write(data);
                gzipStream.close();
                byArray = byteStream.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to gzip data", e);
        }
    }

    public static InputStream getDecodedInputStream(J_N_H_HttpResponse<InputStream> httpResponse) {
        String encoding = BatchProcessor.determineContentEncoding(httpResponse);
        try {
            InputStream inputStream;
            switch (encoding) {
                case "": {
                    inputStream = httpResponse.body();
                    break;
                }
                case "gzip": {
                    inputStream = new GZIPInputStream(httpResponse.body());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(BatchProcessor.jvmdowngrader$concat$getDecodedInputStream$1(encoding));
                }
            }
            return inputStream;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public static String determineContentEncoding(J_N_H_HttpResponse<?> httpResponse) {
        return httpResponse.headers().firstValue("Content-Encoding").orElse("");
    }

    private void sendBatchWithRetry(byte[] payload, int attempt) {
        Config config = this.plugin.getConfig();
        J_N_H_HttpRequest request = J_N_H_HttpRequest.newBuilder().uri(URI.create("https://ingest.mineads.gg/event")).header("X-API-KEY", config.getPluginKey()).header("Content-Type", "application/x-protobuf").header("Content-Encoding", "gzip").header("Accept-Encoding", "gzip").timeout(REQUEST_TIMEOUT).PUT(J_N_H_HttpRequest.BodyPublishers.ofByteArray(payload)).build();
        ((CompletableFuture)this.httpClient.sendAsync(request, J_N_H_HttpResponse.BodyHandlers.ofInputStream()).thenAccept(response -> this.handleResponse((J_N_H_HttpResponse<InputStream>)response, payload, attempt))).exceptionally(throwable -> {
            this.handleSendError((Throwable)throwable, payload, attempt);
            return null;
        });
    }

    private void handleResponse(J_N_H_HttpResponse<InputStream> response, byte[] batch, int attempt) {
        String responseBody;
        Config config = this.plugin.getConfig();
        try (InputStream bodyStream = BatchProcessor.getDecodedInputStream(response);){
            responseBody = new String(BatchProcessor.jvmdg$inlined$readAllBytes(bodyStream), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        int statusCode = response.statusCode();
        if (statusCode >= 200 && statusCode < 300) {
            log.info(BatchProcessor.jvmdowngrader$concat$handleResponse$1(batch.length));
            if (config != null && config.isDebug()) {
                log.info(BatchProcessor.jvmdowngrader$concat$handleResponse$2(statusCode));
            }
        } else if (this.shouldRetry(statusCode) && attempt < 3) {
            long delayMs = this.calculateRetryDelay(attempt);
            log.warning(BatchProcessor.jvmdowngrader$concat$handleResponse$1(statusCode, delayMs, attempt + 1));
            if (config != null && config.isDebug()) {
                log.info(BatchProcessor.jvmdowngrader$concat$handleResponse$1(attempt + 1, delayMs));
                if (!J_L_String.isBlank(responseBody)) {
                    log.info(BatchProcessor.jvmdowngrader$concat$handleResponse$1(responseBody));
                }
            }
            this.scheduler.scheduleAsyncDelayed(() -> this.sendBatchWithRetry(batch, attempt + 1), delayMs, TimeUnit.MILLISECONDS);
        } else {
            log.severe(BatchProcessor.jvmdowngrader$concat$handleResponse$1(statusCode, attempt + 1));
            if (config != null && config.isDebug()) {
                log.info(BatchProcessor.jvmdowngrader$concat$handleResponse$3(attempt + 1));
                if (!J_L_String.isBlank(responseBody)) {
                    log.info(BatchProcessor.jvmdowngrader$concat$handleResponse$1(responseBody));
                }
            }
        }
    }

    private void handleSendError(Throwable throwable, byte[] batch, int attempt) {
        Config config = this.plugin.getConfig();
        if (this.shouldRetryOnException(throwable) && attempt < 3) {
            long delayMs = this.calculateRetryDelay(attempt);
            log.warning(BatchProcessor.jvmdowngrader$concat$handleSendError$1(throwable.getMessage(), delayMs, attempt + 1));
            if (config != null && config.isDebug()) {
                log.info(BatchProcessor.jvmdowngrader$concat$handleSendError$1(attempt + 1, delayMs));
                log.info(BatchProcessor.jvmdowngrader$concat$handleSendError$1(String.valueOf(throwable)));
            }
            this.scheduler.scheduleAsyncDelayed(() -> this.sendBatchWithRetry(batch, attempt + 1), delayMs, TimeUnit.MILLISECONDS);
        } else {
            log.severe(BatchProcessor.jvmdowngrader$concat$handleSendError$1(attempt + 1, throwable.getMessage()));
            if (config != null && config.isDebug()) {
                log.info(BatchProcessor.jvmdowngrader$concat$handleSendError$1(attempt + 1));
                log.info(BatchProcessor.jvmdowngrader$concat$handleSendError$1(String.valueOf(throwable)));
            }
        }
    }

    private boolean shouldRetry(int statusCode) {
        return statusCode == 429 || statusCode >= 500;
    }

    private boolean shouldRetryOnException(Throwable throwable) {
        return throwable instanceof IOException;
    }

    private long calculateRetryDelay(int attempt) {
        long delay = 1000L * (1L << attempt);
        return Math.min(delay, 30000L);
    }

    @Generated
    public BatchProcessor(MineAdsMonitorPlugin plugin, MineAdsScheduler scheduler) {
        this.plugin = plugin;
        this.scheduler = scheduler;
    }

    private static /* synthetic */ String jvmdowngrader$concat$run$1(int n) {
        return "[DEBUG] BatchProcessor run() called, events in queue: " + n;
    }

    private static /* synthetic */ String jvmdowngrader$concat$addEvent$1(int n) {
        return "[DEBUG] Added event to queue, new size: " + n;
    }

    private static /* synthetic */ String jvmdowngrader$concat$processQueueSafely$1(int n) {
        return "[DEBUG] Processing batch of " + n + " events";
    }

    private static /* synthetic */ String jvmdowngrader$concat$processQueueSafely$1(String string) {
        return "[DEBUG] Event types in batch: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$processQueueSafely$2(int n) {
        return "[DEBUG] Serialized batch to " + n + " bytes";
    }

    private static /* synthetic */ String jvmdowngrader$concat$processQueueSafely$2(String string) {
        return "Failed to process batch: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$processQueueSafely$3(int n) {
        return "[DEBUG] Re-queued " + n + " events due to processing failure";
    }

    private static /* synthetic */ String jvmdowngrader$concat$getDecodedInputStream$1(String string) {
        return "Unexpected Content-Encoding: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$handleResponse$1(int n) {
        return "Successfully sent batch of " + n + " bytes";
    }

    private static /* synthetic */ String jvmdowngrader$concat$handleResponse$2(int n) {
        return "[DEBUG] Batch sent successfully with status " + n;
    }

    private static /* synthetic */ String jvmdowngrader$concat$handleResponse$1(int n, long l, int n2) {
        return "Batch send failed with status " + n + ", retrying in " + l + "ms (attempt " + n2 + ")";
    }

    private static /* synthetic */ String jvmdowngrader$concat$handleResponse$1(int n, long l) {
        return "[DEBUG] Scheduling retry attempt " + n + " in " + l + "ms";
    }

    private static /* synthetic */ String jvmdowngrader$concat$handleResponse$1(String string) {
        return "[DEBUG] Error response body: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$handleResponse$1(int n, int n2) {
        return "Batch send failed with status " + n + " after " + n2 + " attempts";
    }

    private static /* synthetic */ String jvmdowngrader$concat$handleResponse$3(int n) {
        return "[DEBUG] Final failure for batch after " + n + " attempts";
    }

    private static /* synthetic */ String jvmdowngrader$concat$handleSendError$1(String string, long l, int n) {
        return "Batch send failed with exception: " + string + ", retrying in " + l + "ms (attempt " + n + ")";
    }

    private static /* synthetic */ String jvmdowngrader$concat$handleSendError$1(int n, long l) {
        return "[DEBUG] Scheduling retry attempt " + n + " in " + l + "ms due to exception";
    }

    private static /* synthetic */ String jvmdowngrader$concat$handleSendError$1(String string) {
        return "[DEBUG] Exception details: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$handleSendError$1(int n, String string) {
        return "Batch send failed after " + n + " attempts: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$handleSendError$1(int n) {
        return "[DEBUG] Final failure for batch after " + n + " attempts due to exception";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$processQueueAsync$0$1(String string) {
        return "Error processing batch: " + string;
    }

    @Stub
    private static /* synthetic */ byte[] jvmdg$inlined$readAllBytes(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
        return out.toByteArray();
    }
}

