/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.velocity.listener;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.command.CommandExecuteEvent;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.api.proxy.Player;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_L_String;
import gg.mineads.monitor.shared.MineAdsMonitorPlugin;
import gg.mineads.monitor.shared.event.TypeUtil;
import gg.mineads.monitor.shared.event.generated.EventType;
import gg.mineads.monitor.shared.event.generated.LuckPermsData;
import gg.mineads.monitor.shared.event.generated.MineAdsEvent;
import gg.mineads.monitor.shared.event.generated.PlayerChatData;
import gg.mineads.monitor.shared.event.generated.PlayerCommandData;
import gg.mineads.monitor.shared.event.generated.PlayerJoinData;
import gg.mineads.monitor.shared.event.generated.PlayerLeaveData;
import gg.mineads.monitor.shared.permission.LuckPermsUtil;
import gg.mineads.monitor.shared.scheduler.MineAdsScheduler;
import gg.mineads.monitor.shared.session.PlayerSessionManager;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Logger;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class PlayerListener {
    @Generated
    private static final Logger log = Logger.getLogger(PlayerListener.class.getName());
    private final MineAdsScheduler scheduler;
    private final MineAdsMonitorPlugin plugin;

    public PlayerListener(MineAdsScheduler scheduler, MineAdsMonitorPlugin plugin) {
        this.scheduler = scheduler;
        this.plugin = plugin;
    }

    @Subscribe(priority=-32768)
    public void onPostLogin(PostLoginEvent event) {
        if (!this.isEventEnabled(EventType.JOIN)) {
            if (this.plugin.getConfig().isDebug()) {
                log.info("[DEBUG] Player join event ignored - JOIN events disabled");
            }
            return;
        }
        Player player = event.getPlayer();
        UUID sessionId = PlayerSessionManager.createSession(player.getUniqueId());
        this.scheduler.runAsync(() -> {
            String virtualHost;
            String clientBrand;
            String locale;
            int protocolVersion;
            String host;
            LuckPermsData luckPermsData = LuckPermsUtil.getLuckPermsData(this.plugin.getConfig(), player.getUniqueId());
            if (this.plugin.getConfig().isDebug()) {
                log.info(gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String.formatted("[DEBUG] Player joined: %s (%s), session: %s, groups: %s", player.getUsername(), player.getUniqueId(), sessionId, luckPermsData != null ? luckPermsData.getGroupsList() : null));
            }
            if (this.plugin.isOutdated() && player.hasPermission("mineadsmonitor.admin")) {
                TextComponent updateMessage = Component.text("[MineAdsMonitor] A new version is available! Download it at: https://modrinth.com/project/mineads-monitor", (TextColor)NamedTextColor.YELLOW);
                player.sendMessage((Component)updateMessage);
            }
            PlayerJoinData.Builder builder = PlayerJoinData.newBuilder().setSessionId(sessionId.toString()).setUuid(player.getUniqueId().toString()).setUsername(player.getUsername()).setOnlineMode(player.isOnlineMode());
            if (luckPermsData != null) {
                builder.setLuckpermsData(luckPermsData);
            }
            if ((host = TypeUtil.getIPString(player.getRemoteAddress())) != null) {
                builder.setHost(host);
            }
            if ((protocolVersion = player.getProtocolVersion().getProtocol()) != -1) {
                builder.setProtocolVersion(protocolVersion);
            }
            if ((locale = Objects.toString(player.getEffectiveLocale(), null)) != null && !J_L_String.isBlank(locale)) {
                builder.setLocale(locale);
            }
            if ((clientBrand = player.getClientBrand()) != null && !J_L_String.isBlank(clientBrand)) {
                builder.setClientBrand(clientBrand);
            }
            if ((virtualHost = TypeUtil.getHostString(player.getVirtualHost().orElse(null))) != null && !J_L_String.isBlank(virtualHost)) {
                builder.setVirtualHost(virtualHost);
            }
            PlayerJoinData data = builder.build();
            MineAdsEvent protoEvent = TypeUtil.createJoinEvent(data);
            this.plugin.getBatchProcessor().addEvent(protoEvent);
        });
    }

    @Subscribe(priority=-32768)
    public void onDisconnect(DisconnectEvent event) {
        if (!this.isEventEnabled(EventType.LEAVE)) {
            if (this.plugin.getConfig().isDebug()) {
                log.info("[DEBUG] Player quit event ignored - LEAVE events disabled");
            }
            return;
        }
        Player player = event.getPlayer();
        UUID sessionId = PlayerSessionManager.removeSession(player.getUniqueId());
        this.scheduler.runAsync(() -> {
            if (sessionId != null) {
                if (this.plugin.getConfig().isDebug()) {
                    log.info(gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String.formatted("[DEBUG] Player quit: %s (%s), session: %s", player.getUsername(), player.getUniqueId(), sessionId));
                }
                PlayerLeaveData data = PlayerLeaveData.newBuilder().setSessionId(sessionId.toString()).build();
                MineAdsEvent protoEvent = TypeUtil.createLeaveEvent(data);
                this.plugin.getBatchProcessor().addEvent(protoEvent);
            } else if (this.plugin.getConfig().isDebug()) {
                log.info(gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String.formatted("[DEBUG] Player quit: %s - no active session found", player.getUsername()));
            }
        });
    }

    @Subscribe(priority=-32768)
    public void onPlayerChat(PlayerChatEvent event) {
        if (event.getResult() == PlayerChatEvent.ChatResult.denied()) {
            return;
        }
        if (!this.isEventEnabled(EventType.CHAT)) {
            if (this.plugin.getConfig().isDebug()) {
                log.info("[DEBUG] Player chat event ignored - CHAT events disabled");
            }
            return;
        }
        Player player = event.getPlayer();
        UUID sessionId = PlayerSessionManager.getSessionId(player.getUniqueId());
        this.scheduler.runAsync(() -> {
            if (sessionId != null) {
                if (this.plugin.getConfig().isDebug()) {
                    String message = PlayerListener.jvmdowngrader$concat$lambda$onCommandExecute$3$1(event.getMessage().substring(0, Math.min(50, event.getMessage().length())), event.getMessage().length() > 50 ? "..." : "");
                    log.info(gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String.formatted("[DEBUG] Player chat: %s - %s", player.getUsername(), message));
                }
                PlayerChatData.Builder dataBuilder = PlayerChatData.newBuilder().setSessionId(sessionId.toString());
                if (!this.plugin.getConfig().isDisableChatContent()) {
                    dataBuilder.setMessage(event.getMessage());
                }
                PlayerChatData data = dataBuilder.build();
                MineAdsEvent protoEvent = TypeUtil.createChatEvent(data);
                this.plugin.getBatchProcessor().addEvent(protoEvent);
            } else if (this.plugin.getConfig().isDebug()) {
                log.info(gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String.formatted("[DEBUG] Player chat ignored: %s - no active session", player.getUsername()));
            }
        });
    }

    @Subscribe(priority=-32768)
    public void onCommandExecute(CommandExecuteEvent event) {
        if (event.getResult() == CommandExecuteEvent.CommandResult.denied()) {
            return;
        }
        if (!this.isEventEnabled(EventType.COMMAND)) {
            if (this.plugin.getConfig().isDebug()) {
                log.info("[DEBUG] Player command event ignored - COMMAND events disabled");
            }
            return;
        }
        CommandSource commandSource = event.getCommandSource();
        if (!(commandSource instanceof Player)) {
            return;
        }
        Player player = (Player)commandSource;
        UUID sessionId = PlayerSessionManager.getSessionId(player.getUniqueId());
        this.scheduler.runAsync(() -> {
            if (sessionId != null) {
                if (this.plugin.getConfig().isDebug()) {
                    String command = PlayerListener.jvmdowngrader$concat$lambda$onCommandExecute$3$1(event.getCommand().substring(0, Math.min(50, event.getCommand().length())), event.getCommand().length() > 50 ? "..." : "");
                    log.info(gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String.formatted("[DEBUG] Player command: %s - %s", player.getUsername(), command));
                }
                PlayerCommandData.Builder dataBuilder = TypeUtil.createCommandDataBuilder(sessionId.toString(), event.getCommand(), false, this.plugin.getConfig().getDefaultMaxCommandArgs(), this.plugin.getConfig().getCommandArgLimits());
                PlayerCommandData data = dataBuilder.build();
                MineAdsEvent protoEvent = TypeUtil.createCommandEvent(data);
                this.plugin.getBatchProcessor().addEvent(protoEvent);
            } else if (this.plugin.getConfig().isDebug()) {
                log.info(gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String.formatted("[DEBUG] Player command ignored: %s - no active session", player.getUsername()));
            }
        });
    }

    private boolean isEventEnabled(EventType eventType) {
        return this.plugin.getConfig().getEnabledEvents().contains(eventType);
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$onCommandExecute$3$1(String string, String string2) {
        return string + string2;
    }
}

