/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.incendo.cloud.injection;

import gg.mineads.monitor.shadow.annotations.apiguardian.api.API;
import gg.mineads.monitor.shadow.geantyref.GenericTypeReflector;
import gg.mineads.monitor.shadow.geantyref.TypeToken;
import gg.mineads.monitor.shadow.incendo.cloud.context.CommandContext;
import gg.mineads.monitor.shadow.incendo.cloud.injection.InjectionRequestImpl;
import gg.mineads.monitor.shadow.incendo.cloud.util.annotation.AnnotationAccessor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.immutables.value.Value;

@API(status=API.Status.STABLE)
@Value.Immutable
public interface InjectionRequest<C> {
    public static <C> @NonNull InjectionRequest<C> of(@NonNull CommandContext<C> context, @NonNull TypeToken<?> injectedType, @NonNull AnnotationAccessor annotationAccessor) {
        return InjectionRequestImpl.of(context, injectedType, annotationAccessor);
    }

    public static <C> @NonNull InjectionRequest<C> of(@NonNull CommandContext<C> context, @NonNull TypeToken<?> injectedType) {
        return InjectionRequestImpl.of(context, injectedType, AnnotationAccessor.empty());
    }

    public @NonNull CommandContext<C> commandContext();

    public @NonNull TypeToken<?> injectedType();

    @Value.Derived
    default public @NonNull Class<?> injectedClass() {
        return GenericTypeReflector.erase(this.injectedType().getType());
    }

    public @NonNull AnnotationAccessor annotationAccessor();
}

