/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.incendo.cloud.permission;

import gg.mineads.monitor.shadow.annotations.apiguardian.api.API;
import gg.mineads.monitor.shadow.incendo.cloud.key.CloudKey;
import gg.mineads.monitor.shadow.incendo.cloud.key.CloudKeyHolder;
import gg.mineads.monitor.shadow.incendo.cloud.permission.Permission;
import gg.mineads.monitor.shadow.incendo.cloud.permission.PermissionResult;
import gg.mineads.monitor.shadow.incendo.cloud.permission.WrappingPredicatePermission;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;

@FunctionalInterface
@API(status=API.Status.STABLE)
public interface PredicatePermission<C>
extends Permission,
CloudKeyHolder<Void> {
    public static <C> PredicatePermission<C> of(@NonNull CloudKey<Void> key, @NonNull Predicate<C> predicate) {
        return new WrappingPredicatePermission<C>(key, predicate);
    }

    public static <C> PredicatePermission<C> of(final @NonNull Predicate<C> predicate) {
        return new PredicatePermission<C>(){

            @Override
            public @NonNull PermissionResult testPermission(@NonNull C sender) {
                return PermissionResult.of(predicate.test(sender), this);
            }
        };
    }

    @Override
    default public @NonNull CloudKey<Void> key() {
        return CloudKey.of(this.getClass().getSimpleName());
    }

    @Override
    default public @NonNull String permissionString() {
        return this.key().name();
    }

    @API(status=API.Status.STABLE)
    public @NonNull PermissionResult testPermission(@NonNull C var1);

    @Override
    default public boolean isEmpty() {
        return false;
    }
}

