/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.kyori.adventure.text.serializer.gson;

import gg.mineads.monitor.shadow.annotations.jetbrains.NotNull;
import gg.mineads.monitor.shadow.annotations.jetbrains.Nullable;
import gg.mineads.monitor.shadow.gson.Gson;
import gg.mineads.monitor.shadow.gson.GsonBuilder;
import gg.mineads.monitor.shadow.gson.JsonElement;
import gg.mineads.monitor.shadow.kyori.adventure.text.Component;
import gg.mineads.monitor.shadow.kyori.adventure.text.serializer.gson.ComponentSerializerImpl;
import gg.mineads.monitor.shadow.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import gg.mineads.monitor.shadow.kyori.adventure.text.serializer.gson.SerializerFactory;
import gg.mineads.monitor.shadow.kyori.adventure.text.serializer.json.JSONOptions;
import gg.mineads.monitor.shadow.kyori.adventure.text.serializer.json.LegacyHoverEventSerializer;
import gg.mineads.monitor.shadow.kyori.adventure.util.Services;
import gg.mineads.monitor.shadow.kyori.option.OptionState;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

final class GsonComponentSerializerImpl
implements GsonComponentSerializer {
    private static final Optional<GsonComponentSerializer.Provider> SERVICE = Services.service(GsonComponentSerializer.Provider.class);
    static final Consumer<GsonComponentSerializer.Builder> BUILDER = SERVICE.map(GsonComponentSerializer.Provider::builder).orElseGet(() -> builder -> {});
    private final Gson serializer;
    private final UnaryOperator<GsonBuilder> populator;
    private final @Nullable LegacyHoverEventSerializer legacyHoverSerializer;
    private final OptionState flags;

    GsonComponentSerializerImpl(OptionState flags, @Nullable LegacyHoverEventSerializer legacyHoverSerializer) {
        this.flags = flags;
        this.legacyHoverSerializer = legacyHoverSerializer;
        this.populator = builder -> {
            builder.registerTypeAdapterFactory(new SerializerFactory(flags, legacyHoverSerializer));
            return builder;
        };
        this.serializer = ((GsonBuilder)this.populator.apply(new GsonBuilder().disableHtmlEscaping())).create();
    }

    @Override
    @NotNull
    public Gson serializer() {
        return this.serializer;
    }

    @Override
    @NotNull
    public UnaryOperator<GsonBuilder> populator() {
        return this.populator;
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull String string) {
        Component component = this.serializer().fromJson(string, Component.class);
        if (component == null) {
            throw ComponentSerializerImpl.notSureHowToDeserialize(string);
        }
        return component;
    }

    @Override
    @Nullable
    public Component deserializeOr(@Nullable String input, @Nullable Component fallback) {
        if (input == null) {
            return fallback;
        }
        Component component = this.serializer().fromJson(input, Component.class);
        if (component == null) {
            return fallback;
        }
        return component;
    }

    @Override
    @NotNull
    public String serialize(@NotNull Component component) {
        return this.serializer().toJson(component);
    }

    @Override
    @NotNull
    public Component deserializeFromTree(@NotNull JsonElement input) {
        Component component = this.serializer().fromJson(input, Component.class);
        if (component == null) {
            throw ComponentSerializerImpl.notSureHowToDeserialize(input);
        }
        return component;
    }

    @Override
    @NotNull
    public JsonElement serializeToTree(@NotNull Component component) {
        return this.serializer().toJsonTree(component);
    }

    @Override
    @NotNull
    public GsonComponentSerializer.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static /* synthetic */ Optional access$000() {
        return SERVICE;
    }

    static final class BuilderImpl
    implements GsonComponentSerializer.Builder {
        private OptionState flags = JSONOptions.byDataVersion();
        private @Nullable LegacyHoverEventSerializer legacyHoverSerializer;

        BuilderImpl() {
            BUILDER.accept(this);
        }

        BuilderImpl(GsonComponentSerializerImpl serializer) {
            this();
            this.flags = serializer.flags;
            this.legacyHoverSerializer = serializer.legacyHoverSerializer;
        }

        @Override
        @NotNull
        public GsonComponentSerializer.Builder options(@NotNull OptionState flags) {
            this.flags = Objects.requireNonNull(flags, "flags");
            return this;
        }

        @Override
        @NotNull
        public GsonComponentSerializer.Builder editOptions(@NotNull Consumer<OptionState.Builder> optionEditor) {
            OptionState.Builder builder = JSONOptions.schema().stateBuilder().values(this.flags);
            Objects.requireNonNull(optionEditor, "flagEditor").accept(builder);
            this.flags = builder.build();
            return this;
        }

        @Override
        @NotNull
        public GsonComponentSerializer.Builder legacyHoverEventSerializer(@Nullable LegacyHoverEventSerializer serializer) {
            this.legacyHoverSerializer = serializer;
            return this;
        }

        @Override
        @NotNull
        public GsonComponentSerializer build() {
            return new GsonComponentSerializerImpl(this.flags, this.legacyHoverSerializer);
        }
    }

    static final class Instances {
        static final GsonComponentSerializer INSTANCE = GsonComponentSerializerImpl.access$000().map(GsonComponentSerializer.Provider::gson).orElseGet(() -> new GsonComponentSerializerImpl(JSONOptions.byDataVersion(), null));
        static final GsonComponentSerializer LEGACY_INSTANCE = GsonComponentSerializerImpl.access$000().map(GsonComponentSerializer.Provider::gsonLegacy).orElseGet(() -> new GsonComponentSerializerImpl(JSONOptions.byDataVersion().at(2525), null));

        Instances() {
        }
    }
}

