/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.configlib;

import gg.mineads.monitor.shadow.configlib.ConfigurationElements;
import gg.mineads.monitor.shadow.configlib.ConfigurationException;
import gg.mineads.monitor.shadow.configlib.ConfigurationProperties;
import gg.mineads.monitor.shadow.configlib.FieldExtractors;
import gg.mineads.monitor.shadow.configlib.Reflect;
import gg.mineads.monitor.shadow.configlib.TypeSerializer;
import gg.mineads.monitor.shadow.configlib.Validator;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import java.util.List;
import java.util.Map;

final class ConfigurationSerializer<T>
extends TypeSerializer<T, ConfigurationElements.FieldElement> {
    private final T defaultInstance = this.newDefaultInstance();

    ConfigurationSerializer(Class<T> configurationType, ConfigurationProperties properties) {
        super(Validator.requireConfigurationClass(configurationType), properties);
    }

    @Override
    public T deserialize(Map<?, ?> serializedConfiguration) {
        Object[] deserializedElements = this.deserializeConfigurationElements(serializedConfiguration);
        List<ConfigurationElements.FieldElement> elements = this.elements();
        T result = this.newDefaultInstance();
        for (int i = 0; i < deserializedElements.length; ++i) {
            ConfigurationElements.FieldElement fieldElement = elements.get(i);
            Reflect.setValue(fieldElement.element(), result, deserializedElements[i]);
        }
        return (T)this.postProcessor.apply(result);
    }

    @Override
    protected void requireSerializableElements() {
        if (this.serializers.isEmpty()) {
            String msg = ConfigurationSerializer.jvmdowngrader$concat$requireSerializableElements$1(this.type.getSimpleName());
            throw new ConfigurationException(msg);
        }
    }

    @Override
    protected String baseDeserializeExceptionMessage(ConfigurationElements.FieldElement element, Object value) {
        return J_L_String.formatted("Deserialization of value '%s' with type '%s' for field '%s' failed.", value, value.getClass(), element.element());
    }

    @Override
    protected List<ConfigurationElements.FieldElement> elements() {
        return J_U_S_Stream.toList(FieldExtractors.CONFIGURATION.extract(this.type).filter(this.properties.getFieldFilter()).map(ConfigurationElements.FieldElement::new));
    }

    @Override
    T newDefaultInstance() {
        return Reflect.callNoParamConstructor(this.type);
    }

    Class<T> getConfigurationType() {
        return this.type;
    }

    @Override
    protected Object getDefaultValueOf(ConfigurationElements.FieldElement element) {
        return Reflect.getValue(element.element(), this.defaultInstance);
    }

    private static /* synthetic */ String jvmdowngrader$concat$requireSerializableElements$1(String string) {
        return "Configuration class '" + string + "' does not contain any (de-)serializable fields.";
    }
}

