/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.configlib;

import gg.mineads.monitor.shadow.configlib.ConfigurationException;
import gg.mineads.monitor.shadow.configlib.FieldExtractor;
import gg.mineads.monitor.shadow.configlib.FieldFilters;
import gg.mineads.monitor.shadow.configlib.Reflect;
import gg.mineads.monitor.shadow.configlib.Validator;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j17.PermittedSubClasses;

@PermittedSubClasses(value={1.class})
@NestMembers(value={1.class})
enum FieldExtractors implements FieldExtractor
{
    CONFIGURATION{

        @Override
        public Stream<Field> extract(Class<?> cls) {
            Validator.requireNonNull(cls, "configuration class");
            Validator.requireConfigurationClass(cls);
            List classes = FieldExtractors.extractClassesWhile(cls, Reflect::isConfigurationClass);
            List<Field> fields = J_U_S_Stream.toList(classes.stream().flatMap(c -> Arrays.stream(c.getDeclaredFields())).filter(FieldFilters.DEFAULT));
            FieldExtractors.requireNoShadowing(fields);
            return fields.stream();
        }
    };


    private static void requireNoShadowing(List<Field> fields) {
        LinkedHashMap map = new LinkedHashMap();
        for (Field field : fields) {
            String fieldName = field.getName();
            Class<?> fieldClass = field.getDeclaringClass();
            if (map.containsKey(fieldName)) {
                Class superClass = (Class)map.get(fieldName);
                String msg = FieldExtractors.jvmdowngrader$concat$requireNoShadowing$1(fieldName, fieldClass.getSimpleName(), fieldName, superClass.getSimpleName());
                throw new ConfigurationException(msg);
            }
            map.put(fieldName, fieldClass);
        }
    }

    private static List<Class<?>> extractClassesWhile(Class<?> cls, Predicate<Class<?>> condition) {
        ArrayList classes = new ArrayList();
        Class<?> current = cls;
        while (condition.test(current)) {
            classes.add(current);
            current = current.getSuperclass();
        }
        Collections.reverse(classes);
        return classes;
    }

    private static /* synthetic */ String jvmdowngrader$concat$requireNoShadowing$1(String string, String string2, String string3, String string4) {
        return "Shadowing of fields is not supported. Field '" + string + "' of class " + string2 + " shadows field '" + string3 + "' of class " + string4 + ".";
    }
}

