/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.configlib;

import gg.mineads.monitor.shadow.configlib.NameFormatter;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j17.PermittedSubClasses;

@PermittedSubClasses(value={1.class, 2.class, 3.class, 4.class, 5.class})
@NestMembers(value={5.class, 4.class, 3.class, 2.class, 1.class})
public enum NameFormatters implements NameFormatter
{
    IDENTITY{

        @Override
        public String format(String name) {
            return name;
        }
    }
    ,
    LOWER_UNDERSCORE{

        @Override
        public String format(String name) {
            StringBuilder builder = new StringBuilder(name.length());
            for (char c : name.toCharArray()) {
                if (Character.isUpperCase(c)) {
                    char lower = Character.toLowerCase(c);
                    builder.append('_').append(lower);
                    continue;
                }
                builder.append(c);
            }
            return builder.toString();
        }
    }
    ,
    UPPER_UNDERSCORE{

        @Override
        public String format(String name) {
            StringBuilder builder = new StringBuilder(name.length());
            for (char c : name.toCharArray()) {
                if (Character.isLowerCase(c)) {
                    builder.append(Character.toUpperCase(c));
                    continue;
                }
                if (Character.isUpperCase(c)) {
                    builder.append('_').append(c);
                    continue;
                }
                builder.append(c);
            }
            return builder.toString();
        }
    }
    ,
    LOWER_KEBAB_CASE{

        @Override
        public String format(String name) {
            StringBuilder builder = new StringBuilder(name.length());
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (Character.isUpperCase(c)) {
                    builder.append('-');
                    builder.append(Character.toLowerCase(c));
                    continue;
                }
                builder.append(c);
            }
            return builder.toString();
        }
    }
    ,
    UPPER_KEBAB_CASE{

        @Override
        public String format(String name) {
            StringBuilder builder = new StringBuilder(name.length());
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (Character.isLowerCase(c)) {
                    builder.append(Character.toUpperCase(c));
                    continue;
                }
                if (Character.isUpperCase(c)) {
                    builder.append('-');
                    builder.append(c);
                    continue;
                }
                builder.append(c);
            }
            return builder.toString();
        }
    };

}

