/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.incendo.cloud.paper.parser;

import gg.mineads.monitor.shadow.annotations.apiguardian.api.API;
import gg.mineads.monitor.shadow.geantyref.TypeFactory;
import gg.mineads.monitor.shadow.geantyref.TypeToken;
import gg.mineads.monitor.shadow.incendo.cloud.bukkit.BukkitCaptionKeys;
import gg.mineads.monitor.shadow.incendo.cloud.bukkit.parser.NamespacedKeyParser;
import gg.mineads.monitor.shadow.incendo.cloud.caption.CaptionVariable;
import gg.mineads.monitor.shadow.incendo.cloud.context.CommandContext;
import gg.mineads.monitor.shadow.incendo.cloud.context.CommandInput;
import gg.mineads.monitor.shadow.incendo.cloud.exception.parsing.ParserException;
import gg.mineads.monitor.shadow.incendo.cloud.paper.parser.RegistryEntryImpl;
import gg.mineads.monitor.shadow.incendo.cloud.parser.ArgumentParseResult;
import gg.mineads.monitor.shadow.incendo.cloud.parser.ArgumentParser;
import gg.mineads.monitor.shadow.incendo.cloud.parser.MappedArgumentParser;
import gg.mineads.monitor.shadow.incendo.cloud.parser.ParserDescriptor;
import gg.mineads.monitor.shadow.incendo.cloud.suggestion.Suggestion;
import gg.mineads.monitor.shadow.incendo.cloud.suggestion.SuggestionProvider;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.immutables.value.Value;

@API(status=API.Status.EXPERIMENTAL)
public final class RegistryEntryParser<C, E extends Keyed>
implements ArgumentParser<C, RegistryEntry<E>>,
SuggestionProvider<C>,
MappedArgumentParser<C, NamespacedKey, RegistryEntry<E>> {
    private final ParserDescriptor<C, NamespacedKey> keyParser = NamespacedKeyParser.namespacedKeyParser();
    private final RegistryKey<E> registryKey;

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C, E extends Keyed> @NonNull ParserDescriptor<C, RegistryEntry<E>> registryEntryParser(RegistryKey<E> registryKey, TypeToken<E> elementType) {
        return ParserDescriptor.of(new RegistryEntryParser<C, E>(registryKey), TypeToken.get(TypeFactory.parameterizedClass(RegistryEntry.class, elementType.getType())));
    }

    public RegistryEntryParser(RegistryKey<E> registryKey) {
        this.registryKey = registryKey;
    }

    @Override
    public @NonNull ArgumentParseResult<RegistryEntry<@NonNull E>> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        return this.keyParser.parser().parse(commandContext, commandInput).flatMapSuccess((T key) -> {
            Registry registry = RegistryAccess.registryAccess().getRegistry(this.registryKey);
            Keyed value = registry.get(key);
            if (value == null) {
                return ArgumentParseResult.failure(new ParseException(key.asString(), this.registryKey, commandContext));
            }
            return ArgumentParseResult.success(RegistryEntryImpl.of(value, key));
        });
    }

    @Override
    public @NonNull ArgumentParser<C, NamespacedKey> baseParser() {
        return this.keyParser.parser();
    }

    @Override
    public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        ArrayList completions = new ArrayList();
        Registry registry = RegistryAccess.registryAccess().getRegistry(this.registryKey);
        registry.stream().map(arg_0 -> ((Registry)registry).getKeyOrThrow(arg_0)).forEach(key -> {
            if (input.hasRemainingInput() && key.getNamespace().equals("minecraft")) {
                completions.add(Suggestion.suggestion(key.getKey()));
            }
            completions.add(Suggestion.suggestion(key.getNamespace() + ':' + key.getKey()));
        });
        return CompletableFuture.completedFuture(completions);
    }

    @Value.Immutable
    public static interface RegistryEntry<E> {
        public E value();

        public NamespacedKey key();
    }

    public static final class ParseException
    extends ParserException {
        private final String input;
        private final RegistryKey<Object> registryKey;

        public ParseException(@NonNull String input, @NonNull RegistryKey<Object> registryKey, @NonNull CommandContext<?> context) {
            super(RegistryEntryParser.class, context, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_REGISTRY_ENTRY_MISSING, CaptionVariable.of("input", input), CaptionVariable.of("registry", registryKey.key().asString()));
            this.input = input;
            this.registryKey = registryKey;
        }

        public @NonNull String input() {
            return this.input;
        }

        public @NonNull RegistryKey<Object> registryKey() {
            return this.registryKey;
        }
    }
}

