/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_net_http;

import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.impl.http.HttpRequestBuilderImpl;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpClient;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpHeaders;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_C_Flow;
import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import xyz.wagyourtail.jvmdg.version.Adapter;

@Adapter(value="Ljava/net/http/HttpRequest;")
public abstract class J_N_H_HttpRequest {
    protected J_N_H_HttpRequest() {
    }

    public static Builder newBuilder() {
        return new HttpRequestBuilderImpl();
    }

    public abstract Optional<BodyPublisher> bodyPublisher();

    public abstract String method();

    public abstract Optional<Duration> timeout();

    public abstract boolean expectContinue();

    public abstract URI uri();

    public abstract Optional<J_N_H_HttpClient.Version> version();

    public abstract J_N_H_HttpHeaders headers();

    public final boolean equals(Object obj) {
        if (!(obj instanceof J_N_H_HttpRequest)) {
            return false;
        }
        J_N_H_HttpRequest that = (J_N_H_HttpRequest)obj;
        if (!that.method().equals(this.method())) {
            return false;
        }
        if (!that.headers().equals(this.headers())) {
            return false;
        }
        return that.uri().equals(this.uri());
    }

    public final int hashCode() {
        return Objects.hash(this.method().hashCode(), this.uri().hashCode(), this.headers().hashCode());
    }

    @Adapter(value="Ljava/net/http/HttpRequest$BodyPublishers;")
    public static class BodyPublishers {
        public static BodyPublisher ofByteArray(byte[] bytes) {
            return BodyPublishers.ofByteArray(bytes, 0, bytes.length);
        }

        public static BodyPublisher ofByteArray(final byte[] bytes, final int offset, final int length) {
            return new BodyPublisher(){

                @Override
                public long contentLength() {
                    return length;
                }

                @Override
                public void subscribe(final J_U_C_Flow.Subscriber<? super ByteBuffer> subscriber) {
                    subscriber.onSubscribe(new J_U_C_Flow.Subscription(){
                        private boolean completed;

                        @Override
                        public void request(long n) {
                            if (n <= 0L) {
                                subscriber.onError(new IllegalArgumentException("n <= 0"));
                                return;
                            }
                            if (this.completed) {
                                return;
                            }
                            this.completed = true;
                            subscriber.onNext(ByteBuffer.wrap(bytes, offset, length));
                            subscriber.onComplete();
                        }

                        @Override
                        public void cancel() {
                            this.completed = true;
                        }
                    });
                }
            };
        }
    }

    @Adapter(value="Ljava/net/http/HttpRequest$Builder;")
    public static interface Builder {
        public Builder uri(URI var1);

        public Builder expectContinue(boolean var1);

        public Builder version(J_N_H_HttpClient.Version var1);

        public Builder header(String var1, String var2);

        public Builder headers(String ... var1);

        public Builder timeout(Duration var1);

        public Builder setHeader(String var1, String var2);

        public Builder GET();

        public Builder POST(BodyPublisher var1);

        public Builder PUT(BodyPublisher var1);

        public Builder DELETE();

        public Builder method(String var1, BodyPublisher var2);

        public J_N_H_HttpRequest build();

        public Builder copy();
    }

    @Adapter(value="Ljava/net/http/HttpRequest$BodyPublisher;")
    public static interface BodyPublisher
    extends J_U_C_Flow.Publisher<ByteBuffer> {
        public long contentLength();
    }
}

