/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.kyori.adventure.nbt;

import gg.mineads.monitor.shadow.annotations.jetbrains.NotNull;
import gg.mineads.monitor.shadow.annotations.jetbrains.Nullable;
import gg.mineads.monitor.shadow.kyori.adventure.nbt.BinaryTag;
import gg.mineads.monitor.shadow.kyori.adventure.nbt.BinaryTagType;
import gg.mineads.monitor.shadow.kyori.adventure.nbt.BinaryTagTypes;
import gg.mineads.monitor.shadow.kyori.adventure.nbt.ListBinaryTag;
import gg.mineads.monitor.shadow.kyori.adventure.nbt.ListBinaryTagImpl;
import java.util.ArrayList;
import java.util.List;

final class ListTagBuilder<T extends BinaryTag>
implements ListBinaryTag.Builder<T> {
    @Nullable
    private List<BinaryTag> tags;
    private final boolean permitsHeterogeneity;
    private BinaryTagType<? extends BinaryTag> elementType;

    ListTagBuilder(boolean permitsHeterogeneity) {
        this(permitsHeterogeneity, BinaryTagTypes.END);
    }

    ListTagBuilder(boolean permitsHeterogeneity, BinaryTagType<? extends BinaryTag> type) {
        this.permitsHeterogeneity = permitsHeterogeneity;
        this.elementType = type;
    }

    @Override
    public @NotNull ListBinaryTag.Builder<T> add(BinaryTag tag) {
        this.elementType = ListBinaryTagImpl.validateTagType(tag, this.elementType, this.permitsHeterogeneity);
        if (this.tags == null) {
            this.tags = new ArrayList<BinaryTag>();
        }
        this.tags.add(tag);
        return this;
    }

    @Override
    public @NotNull ListBinaryTag.Builder<T> add(Iterable<? extends T> tagsToAdd) {
        for (BinaryTag tag : tagsToAdd) {
            this.add(tag);
        }
        return this;
    }

    @Override
    @NotNull
    public ListBinaryTag build() {
        if (this.tags == null) {
            return ListBinaryTag.empty();
        }
        return new ListBinaryTagImpl(this.elementType, this.permitsHeterogeneity, new ArrayList<BinaryTag>(this.tags));
    }
}

