/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.configlib;

import gg.mineads.monitor.shadow.configlib.ConfigurationException;
import gg.mineads.monitor.shadow.configlib.Reflect;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Class;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class Validator {
    private Validator() {
    }

    static <T> T requireNonNull(T object, String argumentName) {
        String msg = Validator.jvmdowngrader$concat$requireNonNull$1(argumentName);
        return Objects.requireNonNull(object, msg);
    }

    static <T> T requireNonNullArrayElement(T element, String type, int index) {
        if (element == null) {
            String msg = Validator.jvmdowngrader$concat$requireNonNullArrayElement$1(type, index);
            throw new ConfigurationException(msg);
        }
        return element;
    }

    static <T> Class<T> requireConfigurationClass(Class<T> cls) {
        Validator.requireNonNull(cls, "type");
        if (!Reflect.isConfigurationClass(cls)) {
            String msg = Validator.jvmdowngrader$concat$requireConfigurationClass$1(cls.getSimpleName());
            throw new ConfigurationException(msg);
        }
        return cls;
    }

    static <T> Class<T> requireRecord(Class<T> cls) {
        Validator.requireNonNull(cls, "type");
        if (!J_L_Class.isRecord(cls)) {
            String msg = Validator.jvmdowngrader$concat$requireRecord$1(cls.getSimpleName());
            throw new ConfigurationException(msg);
        }
        return cls;
    }

    static <T> Class<T> requireConfigurationType(Class<T> type) {
        Validator.requireNonNull(type, "type");
        if (!Reflect.isConfigurationType(type)) {
            String msg = Validator.jvmdowngrader$concat$requireConfigurationType$1(type.getSimpleName());
            throw new ConfigurationException(msg);
        }
        return type;
    }

    static void requirePrimitiveOrWrapperNumberType(Class<?> cls) {
        if (!Reflect.isIntegerType(cls) && !Reflect.isFloatingPointType(cls)) {
            String msg = Validator.jvmdowngrader$concat$requirePrimitiveOrWrapperNumberType$1(cls.getSimpleName());
            throw new IllegalArgumentException(msg);
        }
    }

    static void requireTargetType(Object object) {
        if (object == null) {
            return;
        }
        Class<?> cls = object.getClass();
        if (cls == Boolean.class || cls == Long.class || cls == Double.class || cls == String.class) {
            return;
        }
        if (object instanceof List) {
            List list = (List)object;
            list.forEach(Validator::requireTargetType);
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            map.keySet().forEach(Validator::requireTargetType);
            map.values().forEach(Validator::requireTargetType);
            return;
        }
        String msg = Validator.jvmdowngrader$concat$requireTargetType$1(String.valueOf(object), String.valueOf(object.getClass()));
        throw new ConfigurationException(msg);
    }

    private static /* synthetic */ String jvmdowngrader$concat$requireNonNull$1(String string) {
        return "The " + string + " must not be null.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$requireNonNullArrayElement$1(String string, int n) {
        return "The " + string + " element at index " + n + " must not be null.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$requireConfigurationClass$1(String string) {
        return "Class '" + string + "' must be a configuration.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$requireRecord$1(String string) {
        return "Class '" + string + "' must be a record.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$requireConfigurationType$1(String string) {
        return "Class '" + string + "' must be a configuration or record.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$requirePrimitiveOrWrapperNumberType$1(String string) {
        return "Class " + string + " is not a byte, short, int, long, float, double, or a wrapper type of one of the primitive number types.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$requireTargetType$1(String string, String string2) {
        return "Object '" + string + "' does not have a valid target type. Its type is: " + string2;
    }
}

