/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.configlib;

import gg.mineads.monitor.shadow.configlib.CommentNode;
import gg.mineads.monitor.shadow.configlib.Validator;
import gg.mineads.monitor.shadow.configlib.YamlConfigurationProperties;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_L_String;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;

final class YamlWriter {
    private final OutputStream outputStream;
    private final YamlConfigurationProperties properties;
    private BufferedWriter writer;

    YamlWriter(OutputStream outputStream, YamlConfigurationProperties properties) {
        this.outputStream = Validator.requireNonNull(outputStream, "output stream");
        this.properties = Validator.requireNonNull(properties, "configuration properties");
    }

    YamlWriter(Path configurationFile, YamlConfigurationProperties properties) {
        Validator.requireNonNull(configurationFile, "configuration file");
        try {
            this.outputStream = Files.newOutputStream(configurationFile, new OpenOption[0]);
            this.properties = properties;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeYaml(String yaml, Queue<CommentNode> nodes) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.outputStream, this.properties.getCharset()));){
            this.writer = writer;
            this.writeHeader();
            this.writeContent(yaml, nodes);
            this.writeFooter();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.writer = null;
        }
    }

    private void writeHeader() throws IOException {
        if (this.properties.getHeader() != null) {
            this.writeAsComment(this.properties.getHeader());
            this.writer.newLine();
        }
    }

    private void writeFooter() throws IOException {
        if (this.properties.getFooter() != null) {
            this.writer.newLine();
            this.writeAsComment(this.properties.getFooter());
        }
    }

    private void writeAsComment(String comment) throws IOException {
        String[] lines = comment.split("\n");
        this.writeComments(Arrays.asList(lines), 0);
    }

    private void writeComments(List<String> comments, int indentLevel) throws IOException {
        String indent = J_L_String.repeat("  ", indentLevel);
        for (String comment : comments) {
            if (comment.isEmpty()) {
                this.writer.newLine();
                continue;
            }
            String line = YamlWriter.jvmdowngrader$concat$writeComments$1(indent, comment);
            this.writeLine(line);
        }
    }

    private void writeLine(String line) throws IOException {
        this.writer.write(line);
        this.writer.newLine();
    }

    private void writeContent(String yaml, Queue<CommentNode> nodes) throws IOException {
        if (nodes.isEmpty()) {
            this.writer.write(yaml);
        } else {
            this.writeCommentedYaml(yaml, nodes);
        }
    }

    private void writeCommentedYaml(String yaml, Queue<CommentNode> nodes) throws IOException {
        CommentNode node = nodes.poll();
        int currentIndentLevel = 0;
        for (String line : yaml.split("\n")) {
            if (node == null) {
                this.writeLine(line);
                continue;
            }
            List<String> elementNames = node.elementNames();
            String indent = J_L_String.repeat("  ", currentIndentLevel);
            String lineStart = YamlWriter.jvmdowngrader$concat$writeCommentedYaml$1(indent, elementNames.get(currentIndentLevel));
            if (!line.startsWith(lineStart)) {
                this.writeLine(line);
                continue;
            }
            int commentIndentLevel = elementNames.size() - 1;
            if (currentIndentLevel++ == commentIndentLevel) {
                this.writeComments(node.comments(), commentIndentLevel);
                node = nodes.poll();
                if (node != null) {
                    currentIndentLevel = YamlWriter.lengthCommonPrefix(node.elementNames(), elementNames);
                }
            }
            this.writeLine(line);
        }
    }

    static int lengthCommonPrefix(List<String> l1, List<String> l2) {
        int maxLen = Math.min(l1.size(), l2.size());
        int result = 0;
        for (int i = 0; i < maxLen; ++i) {
            String s2;
            String s1 = l1.get(i);
            if (s1.equals(s2 = l2.get(i))) {
                ++result;
                continue;
            }
            return result;
        }
        return result;
    }

    private static /* synthetic */ String jvmdowngrader$concat$writeComments$1(String string, String string2) {
        return string + "# " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$writeCommentedYaml$1(String string, String string2) {
        return string + string2 + ":";
    }
}

