/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.incendo.cloud.bungee.parser;

import gg.mineads.monitor.shadow.annotations.apiguardian.api.API;
import gg.mineads.monitor.shadow.incendo.cloud.bungee.BungeeCaptionKeys;
import gg.mineads.monitor.shadow.incendo.cloud.caption.CaptionVariable;
import gg.mineads.monitor.shadow.incendo.cloud.component.CommandComponent;
import gg.mineads.monitor.shadow.incendo.cloud.context.CommandContext;
import gg.mineads.monitor.shadow.incendo.cloud.context.CommandInput;
import gg.mineads.monitor.shadow.incendo.cloud.exception.parsing.ParserException;
import gg.mineads.monitor.shadow.incendo.cloud.parser.ArgumentParseResult;
import gg.mineads.monitor.shadow.incendo.cloud.parser.ArgumentParser;
import gg.mineads.monitor.shadow.incendo.cloud.parser.ParserDescriptor;
import gg.mineads.monitor.shadow.incendo.cloud.suggestion.BlockingSuggestionProvider;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PlayerParser<C>
implements ArgumentParser<C, ProxiedPlayer>,
BlockingSuggestionProvider.Strings<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, ProxiedPlayer> playerParser() {
        return ParserDescriptor.of(new PlayerParser<C>(), ProxiedPlayer.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, ProxiedPlayer> playerComponent() {
        return CommandComponent.builder().parser(PlayerParser.playerParser());
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull ProxiedPlayer> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.readString();
        ProxiedPlayer player = ((ProxyServer)commandContext.get("ProxyServer")).getPlayer(input);
        if (player == null) {
            return ArgumentParseResult.failure(new PlayerParseException(input, commandContext));
        }
        return ArgumentParseResult.success(player);
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return ((ProxyServer)commandContext.get("ProxyServer")).getPlayers().stream().map(ProxiedPlayer::getDisplayName).collect(Collectors.toList());
    }

    public static final class PlayerParseException
    extends ParserException {
        private PlayerParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(PlayerParser.class, context, BungeeCaptionKeys.ARGUMENT_PARSE_FAILURE_PLAYER, CaptionVariable.of("input", input));
        }
    }
}

