/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.kyori.adventure.nbt;

import gg.mineads.monitor.shadow.annotations.jetbrains.Debug;
import gg.mineads.monitor.shadow.annotations.jetbrains.NotNull;
import gg.mineads.monitor.shadow.annotations.jetbrains.Nullable;
import gg.mineads.monitor.shadow.kyori.adventure.nbt.AbstractBinaryTag;
import gg.mineads.monitor.shadow.kyori.adventure.nbt.FloatBinaryTag;
import gg.mineads.monitor.shadow.kyori.adventure.nbt.ShadyPines;
import gg.mineads.monitor.shadow.kyori.examination.ExaminableProperty;
import java.util.stream.Stream;

@Debug.Renderer(text="String.valueOf(this.value) + \"f\"", hasChildren="false")
final class FloatBinaryTagImpl
extends AbstractBinaryTag
implements FloatBinaryTag {
    private final float value;

    FloatBinaryTagImpl(float value) {
        this.value = value;
    }

    @Override
    public float value() {
        return this.value;
    }

    @Override
    public byte byteValue() {
        return (byte)(ShadyPines.floor(this.value) & 0xFF);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return ShadyPines.floor(this.value);
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public short shortValue() {
        return (short)(ShadyPines.floor(this.value) & 0xFFFF);
    }

    @Override
    @NotNull
    public Number numberValue() {
        return Float.valueOf(this.value);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FloatBinaryTagImpl that = (FloatBinaryTagImpl)other;
        return Float.floatToIntBits(this.value) == Float.floatToIntBits(that.value);
    }

    public int hashCode() {
        return Float.hashCode(this.value);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("value", this.value));
    }
}

