/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.incendo.cloud.minecraft.extras.parser;

import gg.mineads.monitor.shadow.annotations.apiguardian.api.API;
import gg.mineads.monitor.shadow.geantyref.TypeToken;
import gg.mineads.monitor.shadow.incendo.cloud.minecraft.extras.MinecraftExtrasParserParameters;
import gg.mineads.monitor.shadow.incendo.cloud.minecraft.extras.annotation.specifier.Decoder;
import gg.mineads.monitor.shadow.incendo.cloud.minecraft.extras.parser.ComponentParser;
import gg.mineads.monitor.shadow.incendo.cloud.parser.ParserContributor;
import gg.mineads.monitor.shadow.incendo.cloud.parser.ParserParameters;
import gg.mineads.monitor.shadow.incendo.cloud.parser.ParserRegistry;
import gg.mineads.monitor.shadow.incendo.cloud.parser.StandardParameters;
import gg.mineads.monitor.shadow.incendo.cloud.parser.standard.StringParser;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

@API(status=API.Status.INTERNAL)
public final class ComponentParserContributor
implements ParserContributor {
    @Override
    public <C> void contribute(ParserRegistry<C> registry) {
        try {
            registry.registerAnnotationMapper(Decoder.MiniMessage.class, (annotation, parsedType) -> ParserParameters.single(MinecraftExtrasParserParameters.COMPONENT_DECODER, MiniMessage.miniMessage()::deserialize));
            registry.registerAnnotationMapper(Decoder.Legacy.class, (annotation, parsedType) -> {
                char character = annotation.value();
                return ParserParameters.single(MinecraftExtrasParserParameters.COMPONENT_DECODER, string -> LegacyComponentSerializer.legacy(character).deserialize((String)string));
            });
            registry.registerAnnotationMapper(Decoder.Json.class, (annotation, parsedType) -> {
                boolean downsampleColors = annotation.downsampleColors();
                Function<String, Component> decoder = downsampleColors ? GsonComponentSerializer.colorDownsamplingGson()::deserialize : GsonComponentSerializer.gson()::deserialize;
                return ParserParameters.single(MinecraftExtrasParserParameters.COMPONENT_DECODER, decoder);
            });
            registry.registerAnnotationMapper(Decoder.class, (annotation, parsedType) -> {
                Function<String, ? extends Component> decoder;
                try {
                    decoder = annotation.value().getConstructor(new Class[0]).newInstance(new Object[0]).decoder(parsedType);
                }
                catch (ReflectiveOperationException exception) {
                    throw new IllegalArgumentException("Could not create decoder for " + annotation.value(), exception);
                }
                return ParserParameters.single(MinecraftExtrasParserParameters.COMPONENT_DECODER, decoder);
            });
            registry.registerParserSupplier(TypeToken.get(Component.class), options -> {
                boolean greedy = options.get(StandardParameters.GREEDY, false);
                boolean greedyFlagAware = options.get(StandardParameters.FLAG_YIELDING, false);
                boolean quoted = options.get(StandardParameters.QUOTED, false);
                if (greedyFlagAware && quoted) {
                    throw new IllegalArgumentException("Don't know whether to create GREEDY_FLAG_YIELDING or QUOTED StringArgument.StringParser, both specified.");
                }
                if (greedy && quoted) {
                    throw new IllegalArgumentException("Don't know whether to create GREEDY or QUOTED StringArgument.StringParser, both specified.");
                }
                StringParser.StringMode stringMode = greedyFlagAware ? StringParser.StringMode.GREEDY_FLAG_YIELDING : (greedy ? StringParser.StringMode.GREEDY : (quoted ? StringParser.StringMode.QUOTED : StringParser.StringMode.SINGLE));
                Function<String, Component> decoder = options.get(MinecraftExtrasParserParameters.COMPONENT_DECODER, MiniMessage.miniMessage()::deserialize);
                return new ComponentParser(decoder, stringMode);
            });
        }
        catch (Exception | LinkageError throwable) {
            // empty catch block
        }
    }
}

