/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.incendo.cloud.suggestion;

import gg.mineads.monitor.shadow.annotations.apiguardian.api.API;
import gg.mineads.monitor.shadow.incendo.cloud.context.CommandContext;
import gg.mineads.monitor.shadow.incendo.cloud.suggestion.MappingSuggestionFactory;
import gg.mineads.monitor.shadow.incendo.cloud.suggestion.Suggestion;
import gg.mineads.monitor.shadow.incendo.cloud.suggestion.SuggestionMapper;
import gg.mineads.monitor.shadow.incendo.cloud.suggestion.Suggestions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE)
public interface SuggestionFactory<C, S extends Suggestion> {
    public @NonNull CompletableFuture<@NonNull Suggestions<C, S>> suggest(@NonNull CommandContext<C> var1, @NonNull String var2);

    public @NonNull CompletableFuture<@NonNull Suggestions<C, S>> suggest(@NonNull C var1, @NonNull String var2);

    default public @NonNull Suggestions<C, S> suggestImmediately(@NonNull C sender, @NonNull String input) {
        try {
            return this.suggest(sender, input).join();
        }
        catch (CompletionException completionException) {
            Throwable cause = completionException.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw completionException;
        }
    }

    default public <S2 extends Suggestion> @NonNull SuggestionFactory<C, S2> mapped(@NonNull SuggestionMapper<S2> mapper) {
        return new MappingSuggestionFactory(this, mapper);
    }
}

