/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shared;

import gg.mineads.monitor.shadow.configlib.YamlConfigurations;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_N_F_Files;
import gg.mineads.monitor.shared.AbstractMineAdsMonitorBootstrap;
import gg.mineads.monitor.shared.command.MineAdsCommandManager;
import gg.mineads.monitor.shared.config.Config;
import gg.mineads.monitor.shared.config.ConfigErrorType;
import gg.mineads.monitor.shared.event.BatchProcessor;
import gg.mineads.monitor.shared.update.UpdateChecker;
import java.io.ByteArrayOutputStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class})
public class MineAdsMonitorPlugin {
    @Generated
    private static final Logger log = Logger.getLogger(MineAdsMonitorPlugin.class.getName());
    private final AbstractMineAdsMonitorBootstrap bootstrap;
    private final BatchProcessor batchProcessor;
    private Config config;
    private boolean initialized = false;
    private boolean outdated = false;

    public MineAdsMonitorPlugin(AbstractMineAdsMonitorBootstrap bootstrap) {
        this.bootstrap = bootstrap;
        this.batchProcessor = new BatchProcessor(this, bootstrap.getScheduler());
    }

    public void onEnable() {
        try {
            this.loadConfig();
            if (this.config != null && this.config.isDebug()) {
                log.info("[DEBUG] Starting plugin enable process");
            }
            this.bootstrap.initializePlatform();
            MineAdsCommandManager<?> commandManager = this.bootstrap.createCommandManager(this);
            commandManager.registerCommands();
            this.initializeCoreServices();
            ConfigErrorType error = this.validateConfiguration();
            if (error != null) {
                this.logConfigurationError(error);
                log.info("[MineAdsMonitor] Plugin partially enabled - commands available but core services disabled due to config issues");
            } else if (this.config != null && this.config.isDebug()) {
                log.info("[DEBUG] Configuration loaded successfully");
            }
            this.initialized = true;
            log.info("[MineAdsMonitor] Plugin enabled successfully");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "[MineAdsMonitor] Failed to enable plugin", e);
            this.onDisable();
        }
    }

    public void onDisable() {
        try {
            if (this.config != null && this.config.isDebug()) {
                log.info("[DEBUG] Starting plugin disable process");
            }
            this.shutdownCoreServices();
            this.bootstrap.shutdownPlatform();
            this.initialized = false;
            log.info("[MineAdsMonitor] Plugin disabled successfully");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "[MineAdsMonitor] Error during plugin shutdown", e);
        }
    }

    private void loadConfig() {
        Path configPath = this.bootstrap.getDataFolder().resolve("config.yml");
        this.config = YamlConfigurations.update(configPath, Config.class);
        if (this.config != null && this.config.isDebug()) {
            log.info(MineAdsMonitorPlugin.jvmdowngrader$concat$loadConfig$1(String.valueOf(configPath.toAbsolutePath())));
        }
        try {
            String currentConfigContent = J_N_F_Files.readString(configPath);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            YamlConfigurations.write(outputStream, Config.class, this.config);
            String newConfigContent = outputStream.toString();
            if (!currentConfigContent.equals(newConfigContent)) {
                J_N_F_Files.writeString(configPath, (CharSequence)newConfigContent, new OpenOption[0]);
                if (this.config != null && this.config.isDebug()) {
                    log.info("[DEBUG] Configuration file updated with new defaults");
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "[MineAdsMonitor] Failed to update configuration file", e);
        }
    }

    public boolean hasConfigIssues() {
        return this.validateConfiguration() != null;
    }

    private ConfigErrorType validateConfiguration() {
        if (this.config == null || this.config.getPluginKey() == null || this.config.getPluginKey().isEmpty()) {
            return ConfigErrorType.PLUGIN_KEY_MISSING;
        }
        if (!this.config.getPluginKey().startsWith("pluginkey_")) {
            return ConfigErrorType.PLUGIN_KEY_INVALID_FORMAT;
        }
        if (!this.isValidServerId(this.config.getServerId())) {
            return ConfigErrorType.SERVER_ID_INVALID_FORMAT;
        }
        return null;
    }

    private boolean isValidServerId(String serverId) {
        if (serverId == null || serverId.isEmpty()) {
            return false;
        }
        return serverId.matches("^[a-z0-9-]+$");
    }

    private void initializeCoreServices() {
        this.bootstrap.getScheduler().scheduleAsync(this.batchProcessor, 10L, 10L, TimeUnit.SECONDS);
        if (this.config != null && this.config.isDebug()) {
            log.info("[DEBUG] Batch processor scheduled to run every 10 seconds");
        }
        this.bootstrap.initializeLuckPerms();
        UpdateChecker.checkForUpdates(this);
        this.bootstrap.registerListeners(this);
        if (this.config != null && this.config.isDebug()) {
            log.info("[DEBUG] Event listeners registered");
        }
    }

    private void shutdownCoreServices() {
        this.batchProcessor.run();
    }

    public boolean reloadConfig() {
        try {
            this.loadConfig();
            ConfigErrorType error = this.validateConfig(this.config);
            if (error != null) {
                this.logConfigurationError(error, true);
                return false;
            }
            log.info("[MineAdsMonitor] Configuration reloaded successfully");
            return true;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "[MineAdsMonitor] Failed to reload configuration", e);
            return false;
        }
    }

    private ConfigErrorType validateConfig(Config config) {
        if (config == null || config.getPluginKey() == null || config.getPluginKey().isEmpty()) {
            return ConfigErrorType.PLUGIN_KEY_MISSING;
        }
        if (!config.getPluginKey().startsWith("pluginkey_")) {
            return ConfigErrorType.PLUGIN_KEY_INVALID_FORMAT;
        }
        if (!this.isValidServerId(config.getServerId())) {
            return ConfigErrorType.SERVER_ID_INVALID_FORMAT;
        }
        return null;
    }

    private void logConfigurationError(ConfigErrorType error) {
        this.logConfigurationError(error, false);
    }

    private void logConfigurationError(ConfigErrorType error, boolean isReload) {
        String prefix = isReload ? "[MineAdsMonitor] Reload failed: " : "[MineAdsMonitor] ";
        switch (error) {
            case PLUGIN_KEY_MISSING: {
                log.warning(MineAdsMonitorPlugin.jvmdowngrader$concat$logConfigurationError$1(prefix));
                break;
            }
            case PLUGIN_KEY_INVALID_FORMAT: {
                log.warning(MineAdsMonitorPlugin.jvmdowngrader$concat$logConfigurationError$2(prefix));
                break;
            }
            case SERVER_ID_INVALID_FORMAT: {
                log.warning(MineAdsMonitorPlugin.jvmdowngrader$concat$logConfigurationError$3(prefix));
            }
        }
    }

    @Generated
    public BatchProcessor getBatchProcessor() {
        return this.batchProcessor;
    }

    @Generated
    public Config getConfig() {
        return this.config;
    }

    @Generated
    public boolean isInitialized() {
        return this.initialized;
    }

    @Generated
    public void setOutdated(boolean outdated) {
        this.outdated = outdated;
    }

    @Generated
    public boolean isOutdated() {
        return this.outdated;
    }

    private static /* synthetic */ String jvmdowngrader$concat$loadConfig$1(String string) {
        return "[DEBUG] Configuration file loaded from: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$logConfigurationError$1(String string) {
        return string + "Plugin key not configured. Please set 'pluginKey' in config.yml";
    }

    private static /* synthetic */ String jvmdowngrader$concat$logConfigurationError$2(String string) {
        return string + "Invalid plugin key. Plugin keys must start with 'pluginkey_'. Please check that you used the correct type of key from the MineAds dashboard.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$logConfigurationError$3(String string) {
        return string + "Invalid server id format. Server ids can only contain lowercase letters, numbers, and dashes (e.g., 'survival-main', 'creative-01').";
    }
}

