/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shared.config;

import gg.mineads.monitor.shadow.configlib.Comment;
import gg.mineads.monitor.shadow.configlib.Configuration;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Map;
import gg.mineads.monitor.shared.event.generated.EventType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import lombok.Generated;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

@Configuration
public class Config {
    @Comment(value={"The plugin key for your server. You can get this from the MineAds dashboard. Must start with 'pluginkey_'."})
    private String pluginKey = "";
    @Comment(value={"Unique identifier for this server on the network. Use a descriptive name like 'survival-main' or 'creative-hub'. Only lowercase letters and dashes allowed. Used to distinguish events from different servers."})
    private String serverId = Config.generateDefaultServerId();
    @Comment(value={"Enable/disable tracking of specific event types. By default, all events are enabled."})
    private Set<EventType> enabledEvents = Config.jvmdg$inlined$of(EventType.INITIAL, EventType.EXPIRY, EventType.RENEWAL, EventType.CHARGEBACK, EventType.REFUND, EventType.CHAT, EventType.COMMAND, EventType.JOIN, EventType.LEAVE);
    @Comment(value={"Disable sending chat message content. When enabled (default), full chat message content is sent with chat events. When disabled, only the fact that a message was sent is transmitted."})
    private boolean disableChatContent = false;
    @Comment(value={"Default maximum number of command arguments to send. Set to 0 for no arguments (empty list), 1 for just the command name, or higher for more arguments. Default is 1."})
    private int defaultMaxCommandArgs = 1;
    @Comment(value={"Override the default max arguments for specific commands. Map of command name to max arguments. Command names should not include the leading slash."})
    private Map<String, Integer> commandArgLimits = J_U_Map.of("warp", 2);
    @Comment(value={"Enable debug logging for batch processing events. Useful for troubleshooting."})
    private boolean debug = false;

    private static String generateDefaultServerId() {
        String chars = "abcdefghijklmnopqrstuvwxyz";
        Random random = new Random();
        StringBuilder sb = new StringBuilder("server-");
        for (int i = 0; i < 5; ++i) {
            sb.append(chars.charAt(random.nextInt(chars.length())));
        }
        return sb.toString();
    }

    @Generated
    public String getPluginKey() {
        return this.pluginKey;
    }

    @Generated
    public String getServerId() {
        return this.serverId;
    }

    @Generated
    public Set<EventType> getEnabledEvents() {
        return this.enabledEvents;
    }

    @Generated
    public boolean isDisableChatContent() {
        return this.disableChatContent;
    }

    @Generated
    public int getDefaultMaxCommandArgs() {
        return this.defaultMaxCommandArgs;
    }

    @Generated
    public Map<String, Integer> getCommandArgLimits() {
        return this.commandArgLimits;
    }

    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @Stub(ref=@Ref(value="Ljava/util/Set;"))
    private static /* synthetic */ <E> Set<E> jvmdg$inlined$of(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9) {
        return Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(e1, e2, e3, e4, e5, e6, e7, e8, e9)));
    }
}

