/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shared.event;

import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_L_String;
import gg.mineads.monitor.shared.event.generated.EventType;
import gg.mineads.monitor.shared.event.generated.MineAdsEvent;
import gg.mineads.monitor.shared.event.generated.PlayerChatData;
import gg.mineads.monitor.shared.event.generated.PlayerCommandData;
import gg.mineads.monitor.shared.event.generated.PlayerJoinData;
import gg.mineads.monitor.shared.event.generated.PlayerLeaveData;
import gg.mineads.monitor.shared.event.generated.TransactionData;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Map;

public class TypeUtil {
    private TypeUtil() {
    }

    public static String getHostString(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
            return inetSocketAddress.getHostString();
        }
        return null;
    }

    public static String getIPString(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
            InetAddress inetAddress = inetSocketAddress.getAddress();
            if (inetAddress == null) {
                return null;
            }
            return inetAddress.getHostAddress();
        }
        return null;
    }

    public static MineAdsEvent createJoinEvent(PlayerJoinData data) {
        return MineAdsEvent.newBuilder().setEventType(EventType.JOIN).setTime(System.currentTimeMillis()).setJoinData(data).build();
    }

    public static MineAdsEvent createLeaveEvent(PlayerLeaveData data) {
        return MineAdsEvent.newBuilder().setEventType(EventType.LEAVE).setTime(System.currentTimeMillis()).setLeaveData(data).build();
    }

    public static MineAdsEvent createChatEvent(PlayerChatData data) {
        return MineAdsEvent.newBuilder().setEventType(EventType.CHAT).setTime(System.currentTimeMillis()).setChatData(data).build();
    }

    public static PlayerCommandData.Builder createCommandDataBuilder(String sessionId, String fullCommand, boolean slashPrefixed, int defaultMaxArgs, Map<String, Integer> commandArgLimits) {
        PlayerCommandData.Builder builder = PlayerCommandData.newBuilder().setSessionId(sessionId);
        if (fullCommand == null || J_L_String.isBlank(fullCommand)) {
            return builder.setIsTruncated(false);
        }
        String command = slashPrefixed ? fullCommand.substring(1) : fullCommand;
        String[] parts = command.split("\\s+");
        if (parts.length == 0) {
            return builder.setIsTruncated(false);
        }
        String commandName = parts[0];
        int maxArgs = commandArgLimits.getOrDefault(commandName, defaultMaxArgs);
        ArrayList<String> arguments = new ArrayList<String>();
        boolean isTruncated = false;
        if (maxArgs > 0) {
            arguments.add(commandName);
            for (int i = 1; i < parts.length && arguments.size() < maxArgs; ++i) {
                arguments.add(parts[i]);
            }
            if (parts.length > maxArgs) {
                isTruncated = true;
            }
        }
        return builder.addAllArguments(arguments).setIsTruncated(isTruncated);
    }

    public static MineAdsEvent createCommandEvent(PlayerCommandData data) {
        return MineAdsEvent.newBuilder().setEventType(EventType.COMMAND).setTime(System.currentTimeMillis()).setCommandData(data).build();
    }

    public static MineAdsEvent createTransactionEvent(TransactionData data, EventType eventType) {
        return MineAdsEvent.newBuilder().setEventType(eventType).setTime(System.currentTimeMillis()).setTransactionData(data).build();
    }
}

