/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shared.permission;

import gg.mineads.monitor.shared.config.Config;
import gg.mineads.monitor.shared.event.generated.LuckPermsData;
import java.util.Comparator;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import lombok.Generated;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;

public class LuckPermsUtil {
    @Generated
    private static final Logger log = Logger.getLogger(LuckPermsUtil.class.getName());
    private static Object luckPerms = null;
    private static boolean initialized = false;

    public static void initialize() {
        if (initialized) {
            log.info("[MineAdsMonitor] LuckPerms already initialized, skipping");
            return;
        }
        try {
            luckPerms = LuckPermsProvider.get();
            log.info("[MineAdsMonitor] LuckPerms integration initialized successfully");
        }
        catch (Exception | NoClassDefFoundError e) {
            luckPerms = null;
            log.info("[MineAdsMonitor] LuckPerms not available, permission features will be limited");
        }
        initialized = true;
    }

    public static boolean isAvailable() {
        return luckPerms != null;
    }

    public static LuckPermsData getLuckPermsData(Config config, UUID uuid) {
        if (!LuckPermsUtil.isAvailable()) {
            if (config.isDebug()) {
                log.info(LuckPermsUtil.jvmdowngrader$concat$getLuckPermsData$1(String.valueOf(uuid)));
            }
            return null;
        }
        try {
            LuckPerms luckPermsInstance = (LuckPerms)luckPerms;
            User user = luckPermsInstance.getUserManager().getUser(uuid);
            if (user == null) {
                user = (User)luckPermsInstance.getUserManager().loadUser(uuid).get(30L, TimeUnit.SECONDS);
            }
            if (user == null) {
                if (config.isDebug()) {
                    log.info(LuckPermsUtil.jvmdowngrader$concat$getLuckPermsData$2(String.valueOf(uuid)));
                }
                return null;
            }
            return LuckPermsData.newBuilder().addAllGroups(user.getInheritedGroups(user.getQueryOptions()).stream().sorted(Comparator.comparingInt(group -> group.getWeight().orElse(0))).map(Group::getName)::iterator).build();
        }
        catch (Exception e) {
            log.warning(LuckPermsUtil.jvmdowngrader$concat$getLuckPermsData$1(String.valueOf(uuid), String.valueOf(e)));
            return null;
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$getLuckPermsData$1(String string) {
        return "[DEBUG] LuckPerms not available when retrieving data for UUID: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getLuckPermsData$2(String string) {
        return "[DEBUG] LuckPerms user not found for UUID: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getLuckPermsData$1(String string, String string2) {
        return "[DEBUG] Error retrieving LuckPerms data for UUID: " + string + ", error: " + string2;
    }
}

