/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shared.update;

import gg.mineads.monitor.data.BuildData;
import gg.mineads.monitor.shadow.gson.Gson;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpClient;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpRequest;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpResponse;
import gg.mineads.monitor.shared.MineAdsMonitorPlugin;
import gg.mineads.monitor.shared.update.GitHubRelease;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import lombok.Generated;

public class UpdateChecker {
    @Generated
    private static final Logger log = Logger.getLogger(UpdateChecker.class.getName());
    private static final String GITHUB_API_URL = "https://api.github.com/repos/mineads-gg/mineads-monitor/releases/latest";
    private static final Gson GSON = new Gson();
    private static final J_N_H_HttpClient HTTP_CLIENT = J_N_H_HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();

    public static CompletableFuture<Void> checkForUpdates(MineAdsMonitorPlugin plugin) {
        log.info("[MineAdsMonitor] Checking for updates...");
        J_N_H_HttpRequest request = J_N_H_HttpRequest.newBuilder().uri(URI.create(GITHUB_API_URL)).header("Accept", "application/vnd.github.v3+json").header("User-Agent", UpdateChecker.jvmdowngrader$concat$checkForUpdates$1(BuildData.VERSION)).timeout(Duration.ofSeconds(10L)).GET().build();
        return ((CompletableFuture)((CompletableFuture)HTTP_CLIENT.sendAsync(request, J_N_H_HttpResponse.BodyHandlers.ofString()).thenApply(J_N_H_HttpResponse::body)).thenAccept(response -> UpdateChecker.processUpdateResponse(response, plugin))).exceptionally(throwable -> {
            log.warning(UpdateChecker.jvmdowngrader$concat$lambda$checkForUpdates$1$1(throwable.getMessage()));
            return null;
        });
    }

    private static void processUpdateResponse(String jsonResponse, MineAdsMonitorPlugin plugin) {
        try {
            log.info("[MineAdsMonitor] Processing update response...");
            GitHubRelease latestRelease = GSON.fromJson(jsonResponse, GitHubRelease.class);
            if (latestRelease == null) {
                log.warning("[MineAdsMonitor] Failed to parse update response");
                return;
            }
            String latestVersion = latestRelease.getTag_name();
            if (latestVersion == null || latestVersion.isEmpty()) {
                log.warning("[MineAdsMonitor] No version information found in update response");
                return;
            }
            if (latestVersion.startsWith("v")) {
                latestVersion = latestVersion.substring(1);
            }
            String currentVersion = BuildData.VERSION;
            log.info(UpdateChecker.jvmdowngrader$concat$processUpdateResponse$1(currentVersion));
            log.info(UpdateChecker.jvmdowngrader$concat$processUpdateResponse$2(latestVersion));
            if (UpdateChecker.isNewerVersion(latestVersion, currentVersion)) {
                plugin.setOutdated(true);
                log.info("[MineAdsMonitor] =========================================");
                log.info("[MineAdsMonitor] A new version is available!");
                log.info(UpdateChecker.jvmdowngrader$concat$processUpdateResponse$3(currentVersion));
                log.info(UpdateChecker.jvmdowngrader$concat$processUpdateResponse$4(latestVersion));
                if (latestRelease.getHtml_url() != null) {
                    log.info(UpdateChecker.jvmdowngrader$concat$processUpdateResponse$5(latestRelease.getHtml_url()));
                }
                if (latestRelease.getBody() != null && !latestRelease.getBody().isEmpty()) {
                    log.info("[MineAdsMonitor] Release notes:");
                    log.info(UpdateChecker.jvmdowngrader$concat$processUpdateResponse$6(latestRelease.getBody().replace("\n", "\n[MineAdsMonitor] ")));
                }
                log.info("[MineAdsMonitor] =========================================");
            } else if (latestVersion.equals(currentVersion)) {
                log.info("[MineAdsMonitor] You are running the latest version!");
            } else {
                log.info("[MineAdsMonitor] You are running a development/pre-release version.");
            }
        }
        catch (Exception e) {
            log.severe(UpdateChecker.jvmdowngrader$concat$processUpdateResponse$7(e.getMessage()));
        }
    }

    private static boolean isNewerVersion(String version1, String version2) {
        if (version1 == null || version2 == null) {
            return false;
        }
        try {
            String[] parts1 = version1.split("\\.");
            String[] parts2 = version2.split("\\.");
            int length = Math.max(parts1.length, parts2.length);
            for (int i = 0; i < length; ++i) {
                int v2;
                int v1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
                int n = v2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
                if (v1 > v2) {
                    return true;
                }
                if (v1 >= v2) continue;
                return false;
            }
            return false;
        }
        catch (NumberFormatException e) {
            return version1.compareTo(version2) > 0;
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$checkForUpdates$1(String string) {
        return "MineAdsMonitor/" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$processUpdateResponse$1(String string) {
        return "[MineAdsMonitor] Current version: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$processUpdateResponse$2(String string) {
        return "[MineAdsMonitor] Latest version: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$processUpdateResponse$3(String string) {
        return "[MineAdsMonitor] Current: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$processUpdateResponse$4(String string) {
        return "[MineAdsMonitor] Latest: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$processUpdateResponse$5(String string) {
        return "[MineAdsMonitor] Download: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$processUpdateResponse$6(String string) {
        return "[MineAdsMonitor] " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$processUpdateResponse$7(String string) {
        return "[MineAdsMonitor] Failed to process update response: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$checkForUpdates$1$1(String string) {
        return "[MineAdsMonitor] Failed to check for updates: " + string;
    }
}

