/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.gui;

import fi.dy.masa.litematica.Reference;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.gui.GuiRenderLayer;
import fi.dy.masa.litematica.util.SchematicWorldRefresher;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptions;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_437;

public class GuiConfigs
extends GuiConfigsBase {
    public GuiConfigs() {
        super(10, 50, "litematica", null, "litematica.gui.title.configs", new Object[]{String.format("%s", Reference.MOD_VERSION)});
    }

    public void initGui() {
        super.initGui();
        this.clearOptions();
        if (DataManager.getConfigGuiTab() == ConfigGuiTab.RENDER_LAYERS) {
            GuiBase.openGui((class_437)new GuiRenderLayer());
            return;
        }
        int x = 10;
        int y = 26;
        x += this.createButton(x, y, -1, ConfigGuiTab.GENERIC);
        x += this.createButton(x, y, -1, ConfigGuiTab.INFO_OVERLAYS);
        x += this.createButton(x, y, -1, ConfigGuiTab.VISUALS);
        x += this.createButton(x, y, -1, ConfigGuiTab.COLORS);
        x += this.createButton(x, y, -1, ConfigGuiTab.HOTKEYS);
        x += this.createButton(x, y, -1, ConfigGuiTab.RENDER_LAYERS);
    }

    private int createButton(int x, int y, int width, ConfigGuiTab tab) {
        ButtonGeneric button = new ButtonGeneric(x, y, width, 20, tab.getDisplayName(), new String[0]);
        button.setEnabled(DataManager.getConfigGuiTab() != tab);
        this.addButton((ButtonBase)button, new ButtonListener(tab, this));
        return button.getWidth() + 2;
    }

    protected int getConfigWidth() {
        ConfigGuiTab tab = DataManager.getConfigGuiTab();
        if (tab == ConfigGuiTab.GENERIC || tab == ConfigGuiTab.INFO_OVERLAYS || tab == ConfigGuiTab.VISUALS) {
            return 140;
        }
        if (tab == ConfigGuiTab.COLORS) {
            return 100;
        }
        return super.getConfigWidth();
    }

    protected boolean useKeybindSearch() {
        return DataManager.getConfigGuiTab() == ConfigGuiTab.HOTKEYS;
    }

    public List<GuiConfigsBase.ConfigOptionWrapper> getConfigs() {
        ConfigGuiTab tab = DataManager.getConfigGuiTab();
        Object configs = switch (tab.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Configs.Generic.OPTIONS;
            case 1 -> Configs.InfoOverlays.OPTIONS;
            case 2 -> Configs.Visuals.OPTIONS;
            case 3 -> Configs.Colors.OPTIONS;
            case 4 -> Hotkeys.HOTKEY_LIST;
            case 5 -> Collections.emptyList();
        };
        return GuiConfigsBase.ConfigOptionWrapper.createFor(configs);
    }

    protected void onSettingsChanged() {
        super.onSettingsChanged();
        KeybindSettings settings = Hotkeys.PICK_BLOCK_FIRST.getKeybind().getSettings();
        KeybindSettings settingsNew = KeybindSettings.create((KeybindSettings.Context)settings.getContext(), (KeyAction)settings.getActivateOn(), (boolean)settings.getAllowExtraKeys(), (boolean)settings.isOrderSensitive(), (boolean)settings.isExclusive(), (boolean)true, (boolean)settings.getAllowEmpty());
        Hotkeys.PICK_BLOCK_FIRST.getKeybind().setSettings(settingsNew);
        settings = Hotkeys.PICK_BLOCK_LAST.getKeybind().getSettings();
        settingsNew = KeybindSettings.create((KeybindSettings.Context)settings.getContext(), (KeyAction)settings.getActivateOn(), (boolean)settings.getAllowExtraKeys(), (boolean)settings.isOrderSensitive(), (boolean)settings.isExclusive(), (boolean)true, (boolean)settings.getAllowEmpty());
        Hotkeys.PICK_BLOCK_LAST.getKeybind().setSettings(settingsNew);
        SchematicWorldRefresher.INSTANCE.updateAll();
    }

    public static enum ConfigGuiTab {
        GENERIC("litematica.gui.button.config_gui.generic"),
        INFO_OVERLAYS("litematica.gui.button.config_gui.info_overlays"),
        VISUALS("litematica.gui.button.config_gui.visuals"),
        COLORS("litematica.gui.button.config_gui.colors"),
        HOTKEYS("litematica.gui.button.config_gui.hotkeys"),
        RENDER_LAYERS("litematica.gui.button.config_gui.render_layers");

        private final String translationKey;

        private ConfigGuiTab(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getDisplayName() {
            return StringUtils.translate((String)this.translationKey, (Object[])new Object[0]);
        }
    }

    private record ButtonListener(ConfigGuiTab tab, GuiConfigs parent) implements IButtonActionListener
    {
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            DataManager.setConfigGuiTab(this.tab);
            if (this.tab != ConfigGuiTab.RENDER_LAYERS) {
                this.parent.reCreateListWidget();
                Objects.requireNonNull((WidgetListConfigOptions)this.parent.getListWidget()).resetScrollbarPosition();
                this.parent.initGui();
            } else {
                GuiBase.openGui((class_437)new GuiRenderLayer());
            }
        }
    }
}

