/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.archeryexp.util.json.data;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class BowEffectData {
    private final String effect;
    private final String fallback;
    private final boolean hasTooltip;
    private final int level;
    private final int length;
    private final boolean particles;

    public BowEffectData(String effect, String fallback, int level, int length, boolean particles, boolean hasTooltip) {
        this.effect = effect;
        this.fallback = fallback;
        this.level = level;
        this.length = length;
        this.particles = particles;
        this.hasTooltip = hasTooltip;
    }

    @Nullable
    public class_1291 getEffect() {
        return (class_1291)class_7923.field_41174.method_10223(new class_2960(this.effect));
    }

    @Nullable
    public class_1291 getFallbackEffect() {
        return (class_1291)class_7923.field_41174.method_10223(new class_2960(this.fallback));
    }

    public int getLength() {
        return this.length;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean getParticles() {
        return this.particles;
    }

    public boolean hasTooltip() {
        return this.hasTooltip;
    }

    public void apply(class_1309 entity) {
        if (this.getEffect() != null) {
            this.apply(entity, this.getEffect());
        } else if (this.getFallbackEffect() != null) {
            this.apply(entity, this.getFallbackEffect());
        }
    }

    private void apply(class_1309 entity, class_1291 effect) {
        entity.method_6092(new class_1293(effect, this.length, this.level, true, this.particles));
    }

    public static BowEffectData fromJson(JsonObject json) {
        String effect = json.has("effect") ? json.get("effect").getAsString() : "minecraft:empty";
        String fallback = json.has("fallback") ? json.get("fallback").getAsString() : "minecraft:empty";
        int lvl = json.has("lvl") ? json.get("lvl").getAsInt() : 1;
        int length = json.has("length") ? json.get("length").getAsInt() : 0;
        boolean particles = json.has("particles") && json.get("particles").getAsBoolean();
        boolean hasTooltip = !json.has("tooltip") || json.get("tooltip").getAsBoolean();
        return new BowEffectData(effect, fallback, lvl, length, particles, hasTooltip);
    }
}

