/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.archeryexp.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.infernalstudios.archeryexp.util.mixinterfaces.IBowProperties;

public class BowUtil {
    public static List<class_243> getBowTrajectoryPoints(class_1657 player, IBowProperties bow, float delta) {
        int steps = 200;
        List<class_243> trajectoryPoints = bow.archeryexp$isSpecial() ? BowUtil.calculateTrajectory((class_1309)player, player.method_6058(), BowUtil.getPowerForDrawTime(player.method_6030().method_7935() - player.method_6014(), bow), bow.archeryexp$getRange(), -player.method_36454() - 90.0f, player.method_36455(), 0.05f, steps, delta) : BowUtil.calculateTrajectory((class_1309)player, player.method_6058(), class_1753.method_7722((int)(player.method_6030().method_7935() - player.method_6014())), 3.0f, -player.method_36454() - 90.0f, player.method_36455(), 0.05f, steps, delta);
        return trajectoryPoints;
    }

    private static List<class_243> calculateTrajectory(class_1309 user, class_1268 hand, float power, float range, float yaw, float pitch, float gravity, int steps, float delta) {
        ArrayList<class_243> points = new ArrayList<class_243>();
        class_243 startPosition = user.method_5836(delta);
        class_243 direction = BowUtil.getDirectionVector(yaw, pitch).method_1021((double)(power * range));
        class_243 position = startPosition;
        class_243 velocity = direction;
        float defaultDrag = 0.99f;
        float waterDrag = 0.8f;
        for (int i = 0; i < steps; ++i) {
            if (position.method_1022(startPosition) >= 1.0 && (points.isEmpty() || ((class_243)points.get(points.size() - 1)).method_1022(position) >= 1.0)) {
                points.add(position);
            }
            velocity = user.method_37908().method_8320(new class_2338((int)position.field_1352, (int)position.field_1351, (int)position.field_1350)).method_27852(class_2246.field_10382) ? velocity.method_1021((double)waterDrag) : velocity.method_1021((double)defaultDrag);
            position = position.method_1019(velocity);
            velocity = velocity.method_1031(0.0, (double)(-gravity), 0.0);
            if (position.field_1351 < -64.0) break;
        }
        return points;
    }

    private static class_243 getDirectionVector(float yaw, float pitch) {
        float radYaw = -yaw * ((float)Math.PI / 180);
        float radPitch = -pitch * ((float)Math.PI / 180);
        float x = class_3532.method_15362((float)radPitch) * class_3532.method_15362((float)radYaw);
        float y = class_3532.method_15374((float)radPitch);
        float z = class_3532.method_15362((float)radPitch) * class_3532.method_15374((float)radYaw);
        return new class_243((double)x, (double)y, (double)z);
    }

    public static float getPowerForDrawTime(int drawTime, IBowProperties stack) {
        float power = (float)drawTime / (float)stack.archeryexp$getChargeTime();
        if ((power = (power * power + power * 2.0f) / 3.0f) > 1.0f) {
            power = 1.0f;
        }
        return power;
    }
}

