/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.archeryexp.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7923;
import org.infernalstudios.archeryexp.ArcheryExpansion;
import org.infernalstudios.archeryexp.util.json.data.BowEffectData;
import org.infernalstudios.archeryexp.util.json.data.BowParticleData;
import org.infernalstudios.archeryexp.util.mixinterfaces.IBowProperties;

public class JsonDataLoader {
    public static void loadBowStats(class_3300 resourceManager) {
        for (class_1792 item : class_7923.field_41178) {
            if (!(item instanceof class_1753)) continue;
            class_1753 bowItem = (class_1753)item;
            IBowProperties bow = (IBowProperties)bowItem;
            class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
            class_2960 fileLocation = new class_2960(itemId.method_12836(), "bow_stats/" + itemId.method_12832() + ".json");
            try {
                class_3298 resource = (class_3298)resourceManager.method_14486(fileLocation).orElseThrow();
                try {
                    InputStream input = resource.method_14482();
                    try (InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);){
                        JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        bow.archeryexp$setSpecial(true);
                        bow.archeryexp$setBowCooldown(JsonDataLoader.getI(json, "cooldown", 16));
                        bow.archeryexp$setBaseDamage(JsonDataLoader.getF(json, "base_damage", 1.2f));
                        bow.archeryexp$setChargeTime(JsonDataLoader.getI(json, "draw_time", 16));
                        bow.archeryexp$setRange(JsonDataLoader.getF(json, "range", 1.0f));
                        bow.archeryexp$setBreakResist(JsonDataLoader.getF(json, "break_resist", 0.0f));
                        bow.archeryexp$setBreakChance(JsonDataLoader.getF(json, "break_chance", 0.33f));
                        bow.archeryexp$setWalkSpeed(JsonDataLoader.getF(json, "player_speed", 0.8f));
                        bow.archeryexp$setRecoil(JsonDataLoader.getF(json, "recoil", 0.0f));
                        bow.archeryexp$setOffsetX(JsonDataLoader.getF(json, "arrow_offset_x", 0.0f));
                        bow.archeryexp$setOffsetY(JsonDataLoader.getF(json, "arrow_offset_y", 0.0f));
                        bow.archeryexp$setHasDesc(JsonDataLoader.getBl(json, "has_description", false));
                        bow.archeryexp$setEffects(JsonDataLoader.getDataList(json, "on_fire_effects", BowEffectData::fromJson));
                        bow.archeryexp$setParticles(JsonDataLoader.getDataList(json, "on_fire_particles", BowParticleData::fromJson));
                        ArcheryExpansion.LOGGER.info("Loaded Bow Stats for " + String.valueOf(itemId));
                    }
                    finally {
                        if (input == null) continue;
                        input.close();
                    }
                }
                catch (Exception e) {
                    ArcheryExpansion.LOGGER.info("Failed to load Bow Stats for " + String.valueOf(itemId));
                    bow.archeryexp$setSpecial(false);
                }
            }
            catch (Exception e) {
                ArcheryExpansion.LOGGER.info("No Bow Stats Json file found for " + String.valueOf(itemId));
            }
        }
        ArcheryExpansion.BOW_STAT_PLAYER_LIST.clear();
        ArcheryExpansion.LOGGER.info("Finished Loading Bow Stats");
    }

    public static int getI(JsonObject json, String field, int fallback) {
        return json.has(field) ? json.get(field).getAsInt() : fallback;
    }

    public static float getF(JsonObject json, String field, float fallback) {
        return json.has(field) ? json.get(field).getAsFloat() : fallback;
    }

    public static boolean getBl(JsonObject json, String field, boolean fallback) {
        return json.has(field) ? json.get(field).getAsBoolean() : fallback;
    }

    private static <T> List<T> getDataList(JsonObject json, String field, DataType<T> dataType) {
        ArrayList list = new ArrayList();
        if (json.has(field) && json.get(field).isJsonArray()) {
            JsonArray jsonList = json.getAsJsonArray(field);
            jsonList.forEach(element -> {
                if (element.isJsonObject()) {
                    list.add(dataType.fromJson(element.getAsJsonObject()));
                }
            });
        }
        return list;
    }

    @FunctionalInterface
    public static interface DataType<T> {
        public T fromJson(JsonObject var1);
    }
}

