/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.archeryexp;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.infernalstudios.archeryexp.ArcheryExpansion;
import org.infernalstudios.archeryexp.common.items.ArcheryItems;
import org.infernalstudios.archeryexp.networking.ArcheryNetworkingForge;
import org.infernalstudios.archeryexp.platform.ForgePlatformHelper;
import org.infernalstudios.archeryexp.util.json.JsonDataLoader;

@Mod(value="archeryexp")
public class ArcheryExpansionForge {
    public ArcheryExpansionForge() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ArcheryExpansion.init();
        ForgePlatformHelper.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        ArcheryNetworkingForge.registerPackets();
    }

    @Mod.EventBusSubscriber(modid="archeryexp", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ArcheryExpansionForgeReloadListener {
        @SubscribeEvent
        public static void onAddReloadListeners(AddReloadListenerEvent event) {
            event.addListener((PreparableReloadListener)new SimplePreparableReloadListener<Object>(){

                protected Object m_5944_(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
                    return null;
                }

                protected void m_5787_(Object o, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
                    JsonDataLoader.loadBowStats(resourceManager);
                }

                public String m_7812_() {
                    return "bowstats_reload";
                }
            });
        }

        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            ArcheryExpansion.BOW_STAT_PLAYER_LIST.clear();
        }

        @SubscribeEvent
        public static void onLootTableLoad(LootTableLoadEvent event) {
            ArcheryExpansionForgeReloadListener.addToLootTable(event, BuiltInLootTables.f_78696_, ArcheryItems.IRON_ARROW.get(), 0, 4);
            ArcheryExpansionForgeReloadListener.addToLootTable(event, BuiltInLootTables.f_78689_, ArcheryItems.IRON_ARROW.get(), 0, 4);
            ArcheryExpansionForgeReloadListener.addToLootTable(event, BuiltInLootTables.f_78697_, ArcheryItems.GOLD_ARROW.get(), 2, 7);
            ArcheryExpansionForgeReloadListener.addToLootTable(event, BuiltInLootTables.f_78698_, ArcheryItems.GOLD_ARROW.get(), 0, 5);
            ArcheryExpansionForgeReloadListener.addToLootTable(event, BuiltInLootTables.f_78699_, ArcheryItems.GOLD_ARROW.get(), 1, 5);
            ArcheryExpansionForgeReloadListener.addToLootTable(event, BuiltInLootTables.f_230876_, ArcheryItems.DIAMOND_ARROW.get(), 0, 3);
            ArcheryExpansionForgeReloadListener.addToLootTable(event, BuiltInLootTables.f_78741_, ArcheryItems.DIAMOND_ARROW.get(), 0, 6);
            ArcheryExpansionForgeReloadListener.addToLootTable(event, BuiltInLootTables.f_78697_, ArcheryItems.NETHERITE_ARROW.get(), 0, 2);
        }

        private static void addToLootTable(LootTableLoadEvent event, ResourceLocation id, Item item, int min, int max) {
            if (event.getName().equals((Object)id)) {
                LootPool arrowPool = LootPool.m_79043_().name("archeryexp:arrow_loottable_" + ForgeRegistries.ITEMS.getKey((Object)item).m_135815_()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)))).m_79082_();
                event.getTable().addPool(arrowPool);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="archeryexp", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ItemGroupEvent {
        @SubscribeEvent
        public static void addCreativeTabEvent(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == CreativeModeTabs.f_256797_) {
                ArcheryItems.WEAPONS.forEach(supplier -> event.m_246326_((ItemLike)supplier.get()));
            }
        }
    }
}

