/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.archeryexp.common.entities;

import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.projectile.AbstractArrow;
import org.infernalstudios.archeryexp.common.entities.arrow.DiamondArrow;
import org.infernalstudios.archeryexp.common.entities.arrow.GoldArrow;
import org.infernalstudios.archeryexp.common.entities.arrow.IronArrow;
import org.infernalstudios.archeryexp.common.entities.arrow.NetheriteArrow;
import org.infernalstudios.archeryexp.platform.Services;

public class ArcheryEntityTypes {
    public static final Supplier<EntityType<IronArrow>> IRON_ARROW = ArcheryEntityTypes.registerArrow("iron", IronArrow::new);
    public static final Supplier<EntityType<GoldArrow>> GOLD_ARROW = ArcheryEntityTypes.registerArrow("gold", GoldArrow::new);
    public static final Supplier<EntityType<DiamondArrow>> DIAMOND_ARROW = ArcheryEntityTypes.registerArrow("diamond", DiamondArrow::new);
    public static final Supplier<EntityType<NetheriteArrow>> NETHERITE_ARROW = ArcheryEntityTypes.registerArrow("netherite", NetheriteArrow::new);

    public static <T extends AbstractArrow> Supplier<EntityType<T>> registerArrow(String type, EntityType.EntityFactory<T> factory) {
        return ArcheryEntityTypes.register(type + "_arrow", () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)factory, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20712_("archeryexp:" + type + "_arrow"));
    }

    private static <T extends Entity> Supplier<EntityType<T>> register(String name, Supplier<EntityType<T>> entity) {
        return Services.PLATFORM.register(BuiltInRegistries.f_256780_, new ResourceLocation("archeryexp", name), entity);
    }

    public static void register() {
    }
}

