/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.archeryexp.mixin.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import org.infernalstudios.archeryexp.util.BowUtil;
import org.infernalstudios.archeryexp.util.mixinterfaces.IBowProperties;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public class GuiMixin {
    @Unique
    private static final ResourceLocation BOW_METER = new ResourceLocation("archeryexp", "textures/gui/bow_charge_meter.png");

    @Inject(method={"renderCrosshair"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;defaultBlendFunc()V")})
    private void archeryexp$renderCrosshair(GuiGraphics drawContext, CallbackInfo ci) {
        ItemStack stack;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (stack = player.m_21211_()).m_41720_() instanceof BowItem) {
            int width = drawContext.m_280182_();
            int height = drawContext.m_280206_();
            int y = height / 2 - 16;
            int x = width / 2 - 8;
            drawContext.m_280163_(BOW_METER, x, y, 0.0f, 0.0f, 16, 7, 48, 7);
            IBowProperties properties = (IBowProperties)stack.m_41720_();
            float drawTime = properties.archeryexp$isSpecial() ? BowUtil.getPowerForDrawTime(stack.m_41779_() - player.m_21212_(), properties) : BowItem.m_40661_((int)(player.m_21211_().m_41779_() - player.m_21212_()));
            if (drawTime >= 1.0f) {
                drawContext.m_280163_(BOW_METER, x, y, 32.0f, 0.0f, 16, 7, 48, 7);
            } else {
                drawContext.m_280163_(BOW_METER, x, y, 16.0f, 0.0f, (int)(16.0f * drawTime), 7, 48, 7);
            }
        }
    }
}

