/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.archeryexp.mixin.entity;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.EntityHitResult;
import org.infernalstudios.archeryexp.client.particles.ArcheryParticles;
import org.infernalstudios.archeryexp.common.effects.ArcheryEffects;
import org.infernalstudios.archeryexp.common.enchants.ArcheryEnchants;
import org.infernalstudios.archeryexp.common.misc.ArcheryTags;
import org.infernalstudios.archeryexp.util.ArcheryEnchantUtil;
import org.infernalstudios.archeryexp.util.mixinterfaces.IArrowProperties;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrow.class})
public abstract class AbstractArrowMixin
implements IArrowProperties {
    @Unique
    private int archeryexp$shatteringLvl;
    @Unique
    private int archeryexp$headshotLvl;

    @WrapOperation(method={"onHitEntity(Lnet/minecraft/world/phys/EntityHitResult;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z")})
    private boolean archeryexp$onHitEntity(Entity entity, DamageSource damageSource, float originalDamage, Operation<Boolean> original) {
        AbstractArrow arrow = (AbstractArrow)this;
        MobEffect effect = ArcheryEffects.QUICKDRAW_EFFECT.get();
        float hurtAmount = 0.0f;
        if (entity instanceof LivingEntity) {
            Entity entity2;
            LivingEntity living = (LivingEntity)entity;
            boolean playSound = false;
            if (living.m_21023_(effect)) {
                int hurt = (living.m_21124_(effect).m_19564_() + 1) * 2;
                playSound = true;
                hurtAmount += (float)hurt;
            }
            double headPosition = living.m_20182_().m_82520_((double)0.0, (double)((double)living.m_6972_((Pose)living.m_20089_()).f_20378_ * 0.85), (double)0.0).f_82480_ - 0.17;
            if (this.archeryexp$headshotLvl > 0 && living.m_271807_() && arrow.m_20182_().f_82480_ > headPosition && living.m_6095_().m_204039_(ArcheryTags.ALLOW_HEADSHOT)) {
                hurtAmount += (float)(this.archeryexp$headshotLvl * 2);
                playSound = true;
                entity2 = living.m_9236_();
                if (entity2 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)entity2;
                    serverLevel.m_8767_((ParticleOptions)ArcheryParticles.HEADSHOT.get(), living.m_20185_(), living.m_20188_() + 0.5, living.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (playSound && (entity2 = arrow.m_19749_()) instanceof Player) {
                Player player = (Player)entity2;
                entity.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11686_, entity.m_5720_(), 1.0f, 1.0f);
            }
        }
        return (Boolean)original.call(new Object[]{entity, damageSource, Float.valueOf(originalDamage + hurtAmount)});
    }

    @Inject(method={"onHitEntity"}, at={@At(value="HEAD")})
    private void archeryexp$onHitEntity(EntityHitResult hitResult, CallbackInfo ci) {
        AbstractArrow arrow = (AbstractArrow)this;
        Entity entity = hitResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            boolean bl = target.m_271807_();
            target.m_6168_().forEach(stack -> {
                ArcheryEnchantUtil.enchantmentAction(ArcheryEnchants.FRAGILITY, target, stack, bl, lvl -> stack.m_41622_(2 * lvl, target, ignore -> {}));
                if (this.archeryexp$shatteringLvl > 0 && (double)target.m_217043_().m_188503_(100) < 5.0 * ((double)this.archeryexp$shatteringLvl * 0.5 + 0.5) && target.m_271807_()) {
                    int damage = Math.round((float)this.archeryexp$getDurabilityLeft((ItemStack)stack) * 0.05f);
                    stack.m_41622_(damage, target, ignore -> {});
                }
            });
            Entity entity2 = arrow.m_19749_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity user = (LivingEntity)entity2;
                user.m_6168_().forEach(stack -> {
                    ArcheryEnchantUtil.effectEnchantmentAction(ArcheryEnchants.BABY_FACE, user, stack, bl, MobEffects.f_19596_, 20, true);
                    ArcheryEnchantUtil.effectEnchantmentAction(ArcheryEnchants.FOLLOW_THROUGH, user, stack, bl, MobEffects.f_19600_, 25, true);
                });
            }
        }
    }

    @Override
    public void archeryexp$setShatterLevel(ItemStack stack) {
        this.archeryexp$shatteringLvl = this.archeryexp$setEnchantModLvl(ArcheryEnchants.SHATTERING, stack);
    }

    @Override
    public void archeryexp$setHeadshotLevel(ItemStack stack) {
        this.archeryexp$headshotLvl = this.archeryexp$setEnchantModLvl(ArcheryEnchants.HEADSHOT, stack);
    }

    @Unique
    private int archeryexp$setEnchantModLvl(Supplier<Enchantment> enchant, ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)enchant.get(), (ItemStack)stack);
    }

    @Unique
    public int archeryexp$getDurabilityLeft(ItemStack item) {
        return item.m_41776_() - (item.m_41783_() == null ? 0 : item.m_41783_().m_128451_("Damage"));
    }
}

