/*
 * Decompiled with CFR 0.152.
 */
package gavinx.temperatureapi.api;

import gavinx.temperatureapi.api.HumidityAPI;
import gavinx.temperatureapi.api.SoakedAPI;
import gavinx.temperatureapi.api.TemperatureAPI;
import gavinx.temperatureapi.api.TemperatureResistanceAPI;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public final class BodyTemperatureAPI {
    public static final double NORMAL_BODY_TEMP_C = 36.6;
    public static final double COMFORT_MIN_C = 13.0;
    public static final double COMFORT_MAX_C = 30.0;
    private static final double COOL_RATE_PER_DEGREE_PER_SEC = 0.0045;
    private static final double HEAT_RATE_PER_DEGREE_PER_SEC = 0.0035;
    private static final double HUMIDITY_ACCEL = 1.0;
    private static final double RELAX_FRACTION_PER_SEC = 0.01;
    private static final double CONDUCTION_RATE_PER_SEC = 0.001;
    private static final double SOAKED_COLD_MULT = 1.8;
    private static final double SOAKED_HOT_MULT = 0.6;

    private BodyTemperatureAPI() {
    }

    public static double computeRateCPerSecond(class_1937 world, class_2338 pos) {
        if (world == null || pos == null) {
            return 0.0;
        }
        double ambientC = TemperatureAPI.getTemperatureCelsius(world, pos);
        if (Double.isNaN(ambientC)) {
            return 0.0;
        }
        int humidity = HumidityAPI.getHumidityValue(world, pos);
        TemperatureResistanceAPI.Resistance res = null;
        return BodyTemperatureAPI.computeRateCPerSecond(ambientC, humidity, res, Double.NaN);
    }

    public static double computeRateCPerSecond(class_1657 player) {
        class_2338 pos;
        if (player == null) {
            return 0.0;
        }
        class_1937 world = player.method_37908();
        double ambientC = TemperatureAPI.getTemperatureCelsius(world, pos = player.method_24515());
        if (Double.isNaN(ambientC)) {
            return 0.0;
        }
        int humidity = HumidityAPI.getHumidityValue(world, pos);
        TemperatureResistanceAPI.Resistance res = TemperatureResistanceAPI.computeTotal(player);
        double rate = BodyTemperatureAPI.computeRateCPerSecond(ambientC, humidity, res, Double.NaN);
        if (SoakedAPI.isSoaked(player)) {
            double comfortMin = 13.0 - Math.max(0.0, res.coldC);
            double comfortMax = 30.0 + Math.max(0.0, res.heatC);
            if (ambientC < comfortMin && rate < 0.0) {
                rate *= 1.8;
            } else if (ambientC > comfortMax && rate > 0.0) {
                rate *= 0.6;
            }
        }
        return rate;
    }

    public static double computeRateCPerSecond(class_1657 player, double currentBodyTempC) {
        class_2338 pos;
        if (player == null) {
            return 0.0;
        }
        class_1937 world = player.method_37908();
        double ambientC = TemperatureAPI.getTemperatureCelsius(world, pos = player.method_24515());
        if (Double.isNaN(ambientC)) {
            return 0.0;
        }
        int humidity = HumidityAPI.getHumidityValue(world, pos);
        TemperatureResistanceAPI.Resistance res = TemperatureResistanceAPI.computeTotal(player);
        double rate = BodyTemperatureAPI.computeRateCPerSecond(ambientC, humidity, res, currentBodyTempC);
        if (SoakedAPI.isSoaked(player)) {
            double comfortMin = 13.0 - Math.max(0.0, res.coldC);
            double comfortMax = 30.0 + Math.max(0.0, res.heatC);
            if (ambientC < comfortMin && rate < 0.0) {
                rate *= 1.8;
            } else if (ambientC > comfortMax && rate > 0.0) {
                rate *= 0.6;
            }
        }
        return rate;
    }

    public static double computeRateCPerSecond(double ambientC, int humidityPercent) {
        return BodyTemperatureAPI.computeRateCPerSecond(ambientC, humidityPercent, null, Double.NaN);
    }

    public static double computeRateCPerSecond(double ambientC, int humidityPercent, TemperatureResistanceAPI.Resistance resistance, double currentBodyTempC) {
        if (Double.isNaN(ambientC) || Double.isInfinite(ambientC)) {
            return 0.0;
        }
        humidityPercent = Math.max(0, Math.min(100, humidityPercent));
        double comfortMin = 13.0;
        double comfortMax = 30.0;
        if (resistance != null) {
            comfortMin -= Math.max(0.0, resistance.coldC);
            comfortMax += Math.max(0.0, resistance.heatC);
        }
        double rate = 0.0;
        if (ambientC < comfortMin) {
            double degreesBelow = comfortMin - ambientC;
            rate += -0.0045 * degreesBelow;
        } else if (ambientC > comfortMax) {
            double degreesAbove = ambientC - comfortMax;
            double heat = 0.0035 * degreesAbove;
            if (humidityPercent > 50) {
                double over = (double)(humidityPercent - 50) / 50.0;
                double boost = 1.0 + 1.0 * Math.max(0.0, Math.min(1.0, over));
                heat *= boost;
            }
            rate += heat;
        } else if (!Double.isNaN(currentBodyTempC)) {
            double delta = currentBodyTempC - 36.6;
            rate += -0.01 * delta;
        }
        if (!Double.isNaN(currentBodyTempC)) {
            boolean insideComfort;
            boolean bl = insideComfort = ambientC >= comfortMin && ambientC <= comfortMax;
            if (insideComfort && currentBodyTempC < ambientC) {
                double conduction = 0.001 * (ambientC - currentBodyTempC);
                rate += conduction;
            }
        }
        if (!Double.isNaN(currentBodyTempC) && currentBodyTempC <= ambientC && rate < 0.0) {
            rate = 0.0;
        }
        return rate;
    }

    public static double advanceBodyTemp(class_1937 world, class_2338 pos, double currentBodyTempC, double dtSeconds) {
        if (world == null || pos == null) {
            return currentBodyTempC;
        }
        double ambientC = TemperatureAPI.getTemperatureCelsius(world, pos);
        if (Double.isNaN(ambientC)) {
            return currentBodyTempC;
        }
        int humidity = HumidityAPI.getHumidityValue(world, pos);
        double rate = BodyTemperatureAPI.computeRateCPerSecond(ambientC, humidity, null, currentBodyTempC);
        double dt = Math.max(0.0, dtSeconds);
        double next = currentBodyTempC + rate * dt;
        if (currentBodyTempC >= ambientC && next < ambientC) {
            next = ambientC;
        }
        return next;
    }

    public static double advanceBodyTemp(class_1657 player, double currentBodyTempC, double dtSeconds) {
        if (player == null) {
            return currentBodyTempC;
        }
        double rate = BodyTemperatureAPI.computeRateCPerSecond(player, currentBodyTempC);
        double dt = Math.max(0.0, dtSeconds);
        double next = currentBodyTempC + rate * dt;
        double ambientC = TemperatureAPI.getTemperatureCelsius(player.method_37908(), player.method_24515());
        if (!Double.isNaN(ambientC) && currentBodyTempC >= ambientC && next < ambientC) {
            next = ambientC;
        }
        return next;
    }
}

