/*
 * Decompiled with CFR 0.152.
 */
package gavinx.temperatureapi.api;

import gavinx.temperatureapi.api.BlockThermalAPI;
import gavinx.temperatureapi.api.DayNightAPI;
import gavinx.temperatureapi.api.SeasonsAPI;
import gavinx.temperatureapi.api.biome.BiomeAPI;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_6880;

public final class TemperatureAPI {
    private TemperatureAPI() {
    }

    public static double getBiomeBaseCelsius(class_1937 world, class_2338 pos) {
        if (world == null || pos == null) {
            return Double.NaN;
        }
        return TemperatureAPI.resolveBiomeBaseCelsius(world, pos);
    }

    public static double getSeasonalOffsetCelsius(class_1937 world, class_2338 pos) {
        if (world == null || pos == null) {
            return Double.NaN;
        }
        return SeasonsAPI.temperatureOffsetC(world, pos);
    }

    public static double getDiurnalOffsetCelsius(class_1937 world, class_2338 pos) {
        if (world == null || pos == null) {
            return Double.NaN;
        }
        return DayNightAPI.temperatureOffsetC(world, pos);
    }

    public static double getEnvironmentCelsius(class_1937 world, class_2338 pos) {
        if (world == null || pos == null) {
            return Double.NaN;
        }
        double base = TemperatureAPI.resolveBiomeBaseCelsius(world, pos);
        double seasonal = SeasonsAPI.temperatureOffsetC(world, pos);
        double diurnal = DayNightAPI.temperatureOffsetC(world, pos);
        return base + seasonal + diurnal;
    }

    public static double getBiomeBaseCelsius(class_1657 player) {
        if (player == null) {
            return Double.NaN;
        }
        return TemperatureAPI.getBiomeBaseCelsius(player.method_37908(), player.method_24515());
    }

    public static double getSeasonalOffsetCelsius(class_1657 player) {
        if (player == null) {
            return Double.NaN;
        }
        return TemperatureAPI.getSeasonalOffsetCelsius(player.method_37908(), player.method_24515());
    }

    public static double getDiurnalOffsetCelsius(class_1657 player) {
        if (player == null) {
            return Double.NaN;
        }
        return TemperatureAPI.getDiurnalOffsetCelsius(player.method_37908(), player.method_24515());
    }

    public static double getEnvironmentCelsius(class_1657 player) {
        if (player == null) {
            return Double.NaN;
        }
        return TemperatureAPI.getEnvironmentCelsius(player.method_37908(), player.method_24515());
    }

    public static String getTemperature(class_1937 world, class_2338 pos, Unit unit) {
        if (world == null || pos == null || unit == null) {
            return "N/A";
        }
        double celsius = TemperatureAPI.resolveBiomeTemperatureCelsius(world, pos);
        double value = unit == Unit.FAHRENHEIT ? TemperatureAPI.cToF(celsius) : celsius;
        String suffix = unit == Unit.FAHRENHEIT ? "\u00b0F" : "\u00b0C";
        return String.format("%.1f%s", value, suffix);
    }

    public static String getTemperature(class_1937 world, class_2338 pos, boolean fahrenheit) {
        return TemperatureAPI.getTemperature(world, pos, fahrenheit ? Unit.FAHRENHEIT : Unit.CELSIUS);
    }

    public static String getTemperature(class_1937 world, class_2338 pos, String unit) {
        Unit parsed = TemperatureAPI.parseUnit(unit);
        return TemperatureAPI.getTemperature(world, pos, parsed);
    }

    public static String getTemperature(class_1657 player, Unit unit) {
        if (player == null || unit == null) {
            return "N/A";
        }
        return TemperatureAPI.getTemperature(player.method_37908(), player.method_24515(), unit);
    }

    public static String getTemperature(class_1657 player, boolean fahrenheit) {
        return TemperatureAPI.getTemperature(player, fahrenheit ? Unit.FAHRENHEIT : Unit.CELSIUS);
    }

    public static String getTemperature(class_1657 player, String unit) {
        return TemperatureAPI.getTemperature(player, TemperatureAPI.parseUnit(unit));
    }

    public static double getTemperatureCelsius(class_1937 world, class_2338 pos) {
        if (world == null || pos == null) {
            return Double.NaN;
        }
        return TemperatureAPI.resolveBiomeTemperatureCelsius(world, pos);
    }

    public static double getTemperatureCelsius(class_1657 player) {
        if (player == null) {
            return Double.NaN;
        }
        return TemperatureAPI.getTemperatureCelsius(player.method_37908(), player.method_24515());
    }

    private static double resolveBiomeBaseCelsius(class_1937 world, class_2338 pos) {
        Optional<BiomeAPI.CustomBiome> custom;
        class_6880 entry = world.method_23753(pos);
        String key = BiomeAPI.keyFor((class_6880<class_1959>)entry);
        if (key != null && (custom = BiomeAPI.get(key)).isPresent()) {
            return custom.get().temperature;
        }
        return ((class_1959)entry.comp_349()).method_8712();
    }

    private static double resolveBiomeTemperatureCelsius(class_1937 world, class_2338 pos) {
        double baseC = TemperatureAPI.resolveBiomeBaseCelsius(world, pos);
        double seasonalOffset = SeasonsAPI.temperatureOffsetC(world, pos);
        double diurnalOffset = DayNightAPI.temperatureOffsetC(world, pos);
        double blockOffset = BlockThermalAPI.temperatureOffsetC(world, pos);
        return baseC + seasonalOffset + diurnalOffset + blockOffset;
    }

    private static double cToF(double c) {
        return c * 9.0 / 5.0 + 32.0;
    }

    private static Unit parseUnit(String unit) {
        if (unit == null) {
            return Unit.CELSIUS;
        }
        String u = unit.trim().toUpperCase();
        if (u.equals("F") || u.equals("FAHRENHEIT")) {
            return Unit.FAHRENHEIT;
        }
        return Unit.CELSIUS;
    }

    public static enum Unit {
        CELSIUS,
        FAHRENHEIT;

    }
}

