/*
 * Decompiled with CFR 0.152.
 */
package gavinx.temperatureapi.api;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public final class TemperatureResistanceAPI {
    public static final String NBT_HEAT_TIER = "tempapi_heat_tier";
    public static final String NBT_COLD_TIER = "tempapi_cold_tier";
    public static final double DEFAULT_MAX_HEAT_RESIST_C = 40.0;
    public static final double DEFAULT_MAX_COLD_RESIST_C = 40.0;
    private static final List<ResistanceProvider> PROVIDERS = new ArrayList<ResistanceProvider>();

    private TemperatureResistanceAPI() {
    }

    public static void registerProvider(ResistanceProvider provider) {
        if (provider != null) {
            PROVIDERS.add(provider);
        }
    }

    public static Resistance computeTotal(class_1657 player) {
        if (player == null) {
            return new Resistance(0.0, 0.0);
        }
        double heat = 0.0;
        double cold = 0.0;
        heat += TemperatureResistanceAPI.stackHeatC(player.method_6118(class_1304.field_6169));
        heat += TemperatureResistanceAPI.stackHeatC(player.method_6118(class_1304.field_6174));
        heat += TemperatureResistanceAPI.stackHeatC(player.method_6118(class_1304.field_6172));
        heat += TemperatureResistanceAPI.stackHeatC(player.method_6118(class_1304.field_6166));
        heat += TemperatureResistanceAPI.stackHeatC(player.method_6118(class_1304.field_6173));
        heat += TemperatureResistanceAPI.stackHeatC(player.method_6118(class_1304.field_6171));
        cold += TemperatureResistanceAPI.stackColdC(player.method_6118(class_1304.field_6169));
        cold += TemperatureResistanceAPI.stackColdC(player.method_6118(class_1304.field_6174));
        cold += TemperatureResistanceAPI.stackColdC(player.method_6118(class_1304.field_6172));
        cold += TemperatureResistanceAPI.stackColdC(player.method_6118(class_1304.field_6166));
        cold += TemperatureResistanceAPI.stackColdC(player.method_6118(class_1304.field_6173));
        cold += TemperatureResistanceAPI.stackColdC(player.method_6118(class_1304.field_6171));
        for (ResistanceProvider rp : PROVIDERS) {
            try {
                Resistance extra = rp.get(player);
                if (extra == null) continue;
                heat += Math.max(0.0, extra.heatC);
                cold += Math.max(0.0, extra.coldC);
            }
            catch (Throwable throwable) {}
        }
        heat = Math.min(40.0, heat);
        cold = Math.min(40.0, cold);
        return new Resistance(heat, cold);
    }

    public static double tierToDegrees(int tier) {
        int abs = Math.abs(tier);
        return switch (abs) {
            case 1 -> 2.0;
            case 2 -> 4.0;
            case 3 -> 6.0;
            case 4 -> 8.0;
            case 5 -> 10.0;
            default -> 0.0;
        };
    }

    public static double stackHeatC(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return 0.0;
        }
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return 0.0;
        }
        int tier = 0;
        try {
            if (tag.method_10545(NBT_HEAT_TIER)) {
                tier = tag.method_10550(NBT_HEAT_TIER);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (tier < 0) {
            tier = 0;
        }
        if (tier > 5) {
            tier = 5;
        }
        return TemperatureResistanceAPI.tierToDegrees(tier);
    }

    public static double stackColdC(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return 0.0;
        }
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return 0.0;
        }
        int tier = 0;
        try {
            if (tag.method_10545(NBT_COLD_TIER)) {
                tier = tag.method_10550(NBT_COLD_TIER);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (tier > 0) {
            tier = -tier;
        }
        if (tier < -5) {
            tier = -5;
        }
        return TemperatureResistanceAPI.tierToDegrees(tier);
    }

    public static final class Resistance {
        public final double heatC;
        public final double coldC;

        public Resistance(double heatC, double coldC) {
            this.heatC = Math.max(0.0, heatC);
            this.coldC = Math.max(0.0, coldC);
        }

        public Resistance add(Resistance other) {
            if (other == null) {
                return this;
            }
            return new Resistance(this.heatC + other.heatC, this.coldC + other.coldC);
        }

        public String toString() {
            return "Resistance{" + this.heatC + "C heat, " + this.coldC + "C cold}";
        }
    }

    @FunctionalInterface
    public static interface ResistanceProvider {
        public Resistance get(class_1657 var1);
    }
}

