/*
 * Decompiled with CFR 0.152.
 */
package gavinx.temperatureapi.api.biome;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import gavinx.temperatureapi.TemperatureApi;
import gavinx.temperatureapi.api.biome.BiomeAPI;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class BopDefaults {
    private static final Gson GSON = new GsonBuilder().create();
    private static final String RESOURCE_PATH = "/temperatureapi/default_biomes_bop.json";

    private BopDefaults() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Map<String, BiomeAPI.CustomBiome> defaults() {
        HashMap<String, BiomeAPI.CustomBiome> map = new HashMap<String, BiomeAPI.CustomBiome>();
        try (InputStream in = BopDefaults.class.getResourceAsStream(RESOURCE_PATH);){
            Map map2;
            if (in == null) {
                TemperatureApi.LOGGER.info("No BOP default biome resource found at {} (this is fine if BOP isn't present)", (Object)RESOURCE_PATH);
                Map<String, BiomeAPI.CustomBiome> map3 = Collections.unmodifiableMap(map);
                return map3;
            }
            try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
                JsonElement root = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                if (root == null || !root.isJsonArray()) {
                    throw new JsonParseException("BOP defaults JSON must be an array of entries");
                }
                JsonArray arr = root.getAsJsonArray();
                for (JsonElement el : arr) {
                    if (!el.isJsonObject()) continue;
                    JsonObject obj = el.getAsJsonObject();
                    String biome = BopDefaults.getAsString(obj, "biome", null);
                    Double temp = BopDefaults.getAsDouble(obj, "temperature", null);
                    Integer hum = BopDefaults.getAsInt(obj, "humidity", null);
                    if (biome == null || temp == null || hum == null) continue;
                    map.put(biome, new BiomeAPI.CustomBiome(biome, temp, hum));
                }
                TemperatureApi.LOGGER.info("Loaded {} Biomes O' Plenty default biome entries from {}", (Object)map.size(), (Object)RESOURCE_PATH);
                map2 = Collections.unmodifiableMap(map);
            }
            return map2;
        }
        catch (Exception e) {
            TemperatureApi.LOGGER.error("Failed to load BOP default biomes from {}: {}", (Object)RESOURCE_PATH, (Object)e.getMessage());
            return Collections.unmodifiableMap(map);
        }
    }

    private static String getAsString(JsonObject o, String k, String def) {
        return o.has(k) && o.get(k).isJsonPrimitive() ? o.get(k).getAsString() : def;
    }

    private static Double getAsDouble(JsonObject o, String k, Double def) {
        return o.has(k) && o.get(k).isJsonPrimitive() ? o.get(k).getAsDouble() : def.doubleValue();
    }

    private static Integer getAsInt(JsonObject o, String k, Integer def) {
        return o.has(k) && o.get(k).isJsonPrimitive() ? o.get(k).getAsInt() : def.intValue();
    }
}

