/*
 * Decompiled with CFR 0.152.
 */
package gavinx.temperatureapi.api;

import java.lang.reflect.Method;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public final class SeasonsAPI {
    private static final String SS_MOD_ID = "sereneseasons";

    private SeasonsAPI() {
    }

    public static boolean isLoaded() {
        return FabricLoader.getInstance().isModLoaded(SS_MOD_ID);
    }

    public static String getCurrentSeason(class_1937 world) {
        if (world == null || !SeasonsAPI.isLoaded()) {
            return "N/A";
        }
        try {
            Object state = SeasonsAPI.getSeasonState(world);
            if (state == null) {
                return "N/A";
            }
            String season = SeasonsAPI.invokeNameIfEnum(SeasonsAPI.invokeNoArg(state, "getSeason"));
            String sub = SeasonsAPI.invokeNameIfEnum(SeasonsAPI.invokeNoArg(state, "getSubSeason"));
            if (season != null && sub != null) {
                return SeasonsAPI.prettify(season) + " (" + SeasonsAPI.prettify(sub) + ")";
            }
            if (season != null) {
                return SeasonsAPI.prettify(season);
            }
            if (sub != null) {
                return SeasonsAPI.prettify(sub);
            }
            return state.toString();
        }
        catch (Throwable t) {
            return "N/A";
        }
    }

    public static double temperatureOffsetC(class_1937 world, class_2338 pos) {
        if (world == null || pos == null || !SeasonsAPI.isLoaded()) {
            return 0.0;
        }
        try {
            Object state = SeasonsAPI.getSeasonState(world);
            if (state == null) {
                return 0.0;
            }
            Object seasonObj = SeasonsAPI.invokeNoArg(state, "getSeason");
            Object subObj = SeasonsAPI.invokeNoArg(state, "getSubSeason");
            String season = SeasonsAPI.invokeNameIfEnum(seasonObj);
            String sub = SeasonsAPI.invokeNameIfEnum(subObj);
            if (season == null) {
                return 0.0;
            }
            switch (season) {
                case "WINTER": {
                    return SeasonsAPI.mapSub(sub, -6.0, -9.0, -7.0);
                }
                case "SPRING": {
                    return SeasonsAPI.mapSub(sub, -2.0, 0.0, 2.0);
                }
                case "SUMMER": {
                    return SeasonsAPI.mapSub(sub, 3.0, 6.0, 4.0);
                }
                case "AUTUMN": 
                case "FALL": {
                    return SeasonsAPI.mapSub(sub, 2.0, 0.0, -2.0);
                }
            }
            return 0.0;
        }
        catch (Throwable t) {
            return 0.0;
        }
    }

    private static Object getSeasonState(class_1937 world) throws Exception {
        Class<?> helper = Class.forName("sereneseasons.api.season.SeasonHelper");
        try {
            Method m = helper.getMethod("getSeasonState", class_1937.class);
            return m.invoke(null, world);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            for (Method m : helper.getMethods()) {
                Class<?>[] p;
                if (!m.getName().equals("getSeasonState") || (p = m.getParameterTypes()).length != 1 || !p[0].isInstance(world)) continue;
                return m.invoke(null, world);
            }
            return null;
        }
    }

    private static Object invokeNoArg(Object obj, String methodName) {
        if (obj == null) {
            return null;
        }
        try {
            Method m = obj.getClass().getMethod(methodName, new Class[0]);
            return m.invoke(obj, new Object[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static String invokeNameIfEnum(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Enum) {
            return ((Enum)obj).name();
        }
        try {
            Method m = obj.getClass().getMethod("name", new Class[0]);
            Object v = m.invoke(obj, new Object[0]);
            if (v instanceof String) {
                return (String)v;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return obj.toString();
    }

    private static double mapSub(String sub, double early, double mid, double late) {
        if (sub == null) {
            return mid;
        }
        switch (sub) {
            case "EARLY": {
                return early;
            }
            case "MID": {
                return mid;
            }
            case "LATE": {
                return late;
            }
        }
        return mid;
    }

    private static String prettify(String name) {
        if (name == null) {
            return "";
        }
        String lower = name.toLowerCase();
        return Character.toUpperCase(lower.charAt(0)) + lower.substring(1);
    }
}

