/*
 * Decompiled with CFR 0.152.
 */
package gavinx.temperatureapi.api.biome;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import gavinx.temperatureapi.TemperatureApi;
import gavinx.temperatureapi.api.biome.BiomeAPI;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class DefaultBiomes {
    private static final Gson GSON = new GsonBuilder().create();
    private static final String RESOURCE_PATH = "/temperatureapi/default_biomes.json";
    private static final Map<String, BiomeAPI.CustomBiome> DEFAULTS = DefaultBiomes.loadDefaults();

    private DefaultBiomes() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Map<String, BiomeAPI.CustomBiome> loadDefaults() {
        HashMap<String, BiomeAPI.CustomBiome> map = new HashMap<String, BiomeAPI.CustomBiome>();
        try (InputStream in = DefaultBiomes.class.getResourceAsStream(RESOURCE_PATH);){
            Map map2;
            if (in == null) {
                TemperatureApi.LOGGER.warn("Default biome resource not found at {}. No built-in defaults loaded.", (Object)RESOURCE_PATH);
                Map<String, BiomeAPI.CustomBiome> map3 = Collections.unmodifiableMap(map);
                return map3;
            }
            try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
                JsonElement root = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                if (root == null || !root.isJsonArray()) {
                    throw new JsonParseException("Default biomes JSON must be an array of entries");
                }
                JsonArray arr = root.getAsJsonArray();
                for (JsonElement el : arr) {
                    if (!el.isJsonObject()) continue;
                    JsonObject obj = el.getAsJsonObject();
                    String biome = DefaultBiomes.getAsString(obj, "biome", null);
                    Double temp = DefaultBiomes.getAsDouble(obj, "temperature", null);
                    Integer hum = DefaultBiomes.getAsInt(obj, "humidity", null);
                    if (biome == null || temp == null || hum == null) continue;
                    map.put(biome, new BiomeAPI.CustomBiome(biome, temp, hum));
                }
                TemperatureApi.LOGGER.info("Loaded {} built-in default biome entries from {}", (Object)map.size(), (Object)RESOURCE_PATH);
                map2 = Collections.unmodifiableMap(map);
            }
            return map2;
        }
        catch (Exception e) {
            TemperatureApi.LOGGER.error("Failed to load built-in default biomes from {}: {}", (Object)RESOURCE_PATH, (Object)e.getMessage());
            return Collections.unmodifiableMap(map);
        }
    }

    public static Map<String, BiomeAPI.CustomBiome> defaults() {
        return DEFAULTS;
    }

    private static String getAsString(JsonObject o, String k, String def) {
        return o.has(k) && o.get(k).isJsonPrimitive() ? o.get(k).getAsString() : def;
    }

    private static Double getAsDouble(JsonObject o, String k, Double def) {
        return o.has(k) && o.get(k).isJsonPrimitive() ? o.get(k).getAsDouble() : def.doubleValue();
    }

    private static Integer getAsInt(JsonObject o, String k, Integer def) {
        return o.has(k) && o.get(k).isJsonPrimitive() ? o.get(k).getAsInt() : def.intValue();
    }
}

