/*
 * Decompiled with CFR 0.152.
 */
package gavinx.temperatureapi.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public final class BlockThermalAPI {
    private static final Map<class_2248, ThermalSource> SIMPLE = new ConcurrentHashMap<class_2248, ThermalSource>();
    private static final List<Provider> PROVIDERS = new ArrayList<Provider>();
    private static volatile int MAX_SOURCE_RANGE = 0;

    private BlockThermalAPI() {
    }

    public static void register(class_2248 block, double deltaC, int range) {
        Objects.requireNonNull(block, "block");
        ThermalSource ts = new ThermalSource(deltaC, range);
        SIMPLE.put(block, ts);
        if (ts.range > MAX_SOURCE_RANGE) {
            MAX_SOURCE_RANGE = ts.range;
        }
    }

    public static void register(Provider provider) {
        if (provider != null) {
            PROVIDERS.add(provider);
        }
    }

    public static double temperatureOffsetC(class_1937 world, class_2338 atPos) {
        if (world == null || atPos == null) {
            return 0.0;
        }
        double cached = Cache.get(world, atPos);
        if (!Double.isNaN(cached)) {
            return cached;
        }
        int maxR = Math.max(0, MAX_SOURCE_RANGE);
        if (maxR == 0 && PROVIDERS.isEmpty()) {
            Cache.put(world, atPos, 0.0);
            return 0.0;
        }
        double sum = 0.0;
        for (int dx = -maxR; dx <= maxR; ++dx) {
            for (int dy = -maxR; dy <= maxR; ++dy) {
                for (int dz = -maxR; dz <= maxR; ++dz) {
                    double dist;
                    ThermalSource ts;
                    class_2338 bp;
                    class_2680 state;
                    if (dx == 0 && dy == 0 && dz == 0 || (state = world.method_8320(bp = atPos.method_10069(dx, dy, dz))).method_26215() || (ts = BlockThermalAPI.resolve(world, bp, state)) == null || ts.range <= 0 || ts.deltaC == 0.0 || (dist = atPos.method_46558().method_1022(bp.method_46558())) > (double)ts.range + 0.5 || !BlockThermalAPI.hasLineOfSight(world, atPos, bp)) continue;
                    sum += ts.deltaC;
                }
            }
        }
        Cache.put(world, atPos, sum);
        return sum;
    }

    private static ThermalSource resolve(class_1937 world, class_2338 pos, class_2680 state) {
        ThermalSource ts = SIMPLE.get(state.method_26204());
        if (ts != null) {
            return ts;
        }
        if (!PROVIDERS.isEmpty()) {
            for (Provider p : PROVIDERS) {
                try {
                    ThermalSource dyn = p.get(world, pos, state);
                    if (dyn == null) continue;
                    if (dyn.range > MAX_SOURCE_RANGE) {
                        MAX_SOURCE_RANGE = dyn.range;
                    }
                    if (dyn.deltaC == 0.0 || dyn.range <= 0) continue;
                    return dyn;
                }
                catch (Throwable throwable) {
                }
            }
        }
        return null;
    }

    private static boolean hasLineOfSight(class_1937 world, class_2338 from, class_2338 to) {
        class_243 end;
        class_243 start = from.method_46558();
        class_3959 ctx = new class_3959(start, end = to.method_46558(), class_3959.class_3960.field_17558, class_3959.class_242.field_1347, null);
        class_3965 hit = world.method_17742(ctx);
        if (hit == null) {
            return true;
        }
        if (hit.method_17783() == class_239.class_240.field_1333) {
            return true;
        }
        class_2338 hitPos = hit.method_17777();
        return hitPos != null && hitPos.equals((Object)to);
    }

    public static final class ThermalSource {
        public final double deltaC;
        public final int range;

        public ThermalSource(double deltaC, int range) {
            this.deltaC = deltaC;
            this.range = Math.max(0, range);
        }

        public String toString() {
            return "ThermalSource{" + this.deltaC + "C, r=" + this.range + "}";
        }
    }

    private static final class Cache {
        private static final long TTL_TICKS = 80L;
        private static final Map<WorldKey, Map<Long, Entry>> CACHE = new ConcurrentHashMap<WorldKey, Map<Long, Entry>>();

        private Cache() {
        }

        static double get(class_1937 world, class_2338 pos) {
            WorldKey wk = WorldKey.of(world);
            Map<Long, Entry> map = CACHE.get(wk);
            if (map == null) {
                return Double.NaN;
            }
            Entry e = map.get(pos.method_10063());
            if (e == null) {
                return Double.NaN;
            }
            long now = world.method_8510();
            if (now - e.tick <= 80L) {
                return e.value;
            }
            map.remove(pos.method_10063());
            return Double.NaN;
        }

        static void put(class_1937 world, class_2338 pos, double value) {
            WorldKey wk = WorldKey.of(world);
            CACHE.computeIfAbsent(wk, k -> new ConcurrentHashMap()).put(pos.method_10063(), new Entry(world.method_8510(), value));
        }

        record WorldKey(String id) {
            static WorldKey of(class_1937 world) {
                class_2960 key = world.method_27983().method_29177();
                return new WorldKey(key.toString());
            }
        }

        record Entry(long tick, double value) {
        }
    }

    @FunctionalInterface
    public static interface Provider {
        public ThermalSource get(class_1937 var1, class_2338 var2, class_2680 var3);
    }
}

