/*
 * Decompiled with CFR 0.152.
 */
package gavinx.temperatureapi.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import gavinx.temperatureapi.BodyTemperatureState;
import gavinx.temperatureapi.api.BodyTemperatureAPI;
import gavinx.temperatureapi.api.HumidityAPI;
import gavinx.temperatureapi.api.SeasonsAPI;
import gavinx.temperatureapi.api.SoakedAPI;
import gavinx.temperatureapi.api.TemperatureAPI;
import gavinx.temperatureapi.api.TemperatureResistanceAPI;
import gavinx.temperatureapi.api.biome.BiomeAPI;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_6880;

public final class DebugCommands {
    private DebugCommands() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"temperatureapi").requires(src -> src.method_9259(0))).executes(ctx -> DebugCommands.executeInfo((CommandContext<class_2168>)ctx, null, null))).then(DebugCommands.unitArg().executes(ctx -> DebugCommands.executeInfo((CommandContext<class_2168>)ctx, DebugCommands.getUnitArg((CommandContext<class_2168>)ctx), null)).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(ctx -> DebugCommands.executeInfo((CommandContext<class_2168>)ctx, DebugCommands.getUnitArg((CommandContext<class_2168>)ctx), class_2262.method_9696((CommandContext)ctx, (String)"pos")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"temp").executes(ctx -> DebugCommands.executeTemp((CommandContext<class_2168>)ctx, null, null))).then(DebugCommands.unitArg().executes(ctx -> DebugCommands.executeTemp((CommandContext<class_2168>)ctx, DebugCommands.getUnitArg((CommandContext<class_2168>)ctx), null)).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(ctx -> DebugCommands.executeTemp((CommandContext<class_2168>)ctx, DebugCommands.getUnitArg((CommandContext<class_2168>)ctx), class_2262.method_9696((CommandContext)ctx, (String)"pos"))))))).then(class_2170.method_9247((String)"resistance").executes(ctx -> DebugCommands.executeResistance((CommandContext<class_2168>)ctx)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"humidity").executes(ctx -> DebugCommands.executeHumidity((CommandContext<class_2168>)ctx, null))).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(ctx -> DebugCommands.executeHumidity((CommandContext<class_2168>)ctx, class_2262.method_9696((CommandContext)ctx, (String)"pos")))))).then(class_2170.method_9247((String)"season").executes(ctx -> DebugCommands.executeSeason((CommandContext<class_2168>)ctx)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"body").executes(ctx -> DebugCommands.executeBodyTemp((CommandContext<class_2168>)ctx))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.word()).executes(ctx -> DebugCommands.executeBodySet((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"value"))))))).then(class_2170.method_9247((String)"soaked").executes(ctx -> DebugCommands.executeSoaked((CommandContext<class_2168>)ctx)))).then(class_2170.method_9247((String)"biome").executes(ctx -> DebugCommands.executeBiome((CommandContext<class_2168>)ctx))));
    }

    private static ArgumentBuilder<class_2168, ?> unitArg() {
        return class_2170.method_9244((String)"unit", (ArgumentType)StringArgumentType.word());
    }

    private static TemperatureAPI.Unit getUnitArg(CommandContext<class_2168> ctx) {
        String up;
        if (!ctx.getNodes().stream().anyMatch(n -> n.getNode().getName().equals("unit"))) {
            return null;
        }
        String u = StringArgumentType.getString(ctx, (String)"unit");
        String string = up = u == null ? "" : u.trim().toUpperCase();
        if (up.equals("F") || up.equals("FAHRENHEIT")) {
            return TemperatureAPI.Unit.FAHRENHEIT;
        }
        if (up.equals("C") || up.equals("CELSIUS")) {
            return TemperatureAPI.Unit.CELSIUS;
        }
        return null;
    }

    private static int executeInfo(CommandContext<class_2168> ctx, TemperatureAPI.Unit unit, class_2338 posArg) {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 player = DebugCommands.getPlayerOrFeedback(src);
        if (player == null) {
            return 0;
        }
        class_1937 world = player.method_37908();
        class_2338 pos = posArg != null ? posArg : player.method_24515();
        String tempOut = unit == null ? TemperatureAPI.getTemperature(world, pos, TemperatureAPI.Unit.CELSIUS) + " / " + TemperatureAPI.getTemperature(world, pos, TemperatureAPI.Unit.FAHRENHEIT) : TemperatureAPI.getTemperature(world, pos, unit);
        String humidityOut = HumidityAPI.getHumidity(world, pos);
        String season = SeasonsAPI.getCurrentSeason(world);
        src.method_9226(() -> class_2561.method_43470((String)("Temperature: " + tempOut + ", Humidity: " + humidityOut + ", Season: " + season)), false);
        return 1;
    }

    private static int executeTemp(CommandContext<class_2168> ctx, TemperatureAPI.Unit unit, class_2338 posArg) {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 player = DebugCommands.getPlayerOrFeedback(src);
        if (player == null) {
            return 0;
        }
        class_1937 world = player.method_37908();
        class_2338 pos = posArg != null ? posArg : player.method_24515();
        String out = unit == null ? TemperatureAPI.getTemperature(world, pos, TemperatureAPI.Unit.CELSIUS) + " / " + TemperatureAPI.getTemperature(world, pos, TemperatureAPI.Unit.FAHRENHEIT) : TemperatureAPI.getTemperature(world, pos, unit);
        double currentBody = BodyTemperatureState.getC(player);
        double rate = BodyTemperatureAPI.computeRateCPerSecond((class_1657)player, currentBody);
        src.method_9226(() -> class_2561.method_43470((String)("Temperature: " + out + ", Passive dT/dt (homeostasis): " + String.format("%.5f", rate) + " \u00b0C/s")), false);
        return 1;
    }

    private static int executeHumidity(CommandContext<class_2168> ctx, class_2338 posArg) {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 player = DebugCommands.getPlayerOrFeedback(src);
        if (player == null) {
            return 0;
        }
        class_1937 world = player.method_37908();
        class_2338 pos = posArg != null ? posArg : player.method_24515();
        String out = HumidityAPI.getHumidity(world, pos);
        src.method_9226(() -> class_2561.method_43470((String)("Humidity: " + out)), false);
        return 1;
    }

    private static int executeSeason(CommandContext<class_2168> ctx) {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 player = DebugCommands.getPlayerOrFeedback(src);
        if (player == null) {
            return 0;
        }
        class_1937 world = player.method_37908();
        String season = SeasonsAPI.getCurrentSeason(world);
        double offset = SeasonsAPI.temperatureOffsetC(world, player.method_24515());
        src.method_9226(() -> class_2561.method_43470((String)("Season: " + season + " (offset: " + String.format("%.1f", offset) + "\u00b0C)")), false);
        return 1;
    }

    private static int executeResistance(CommandContext<class_2168> ctx) {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 player = DebugCommands.getPlayerOrFeedback(src);
        if (player == null) {
            return 0;
        }
        TemperatureResistanceAPI.Resistance r = TemperatureResistanceAPI.computeTotal((class_1657)player);
        src.method_9226(() -> class_2561.method_43470((String)("Resistance: +" + r.heatC + "\u00b0C heat, +" + r.coldC + "\u00b0C cold")), false);
        return 1;
    }

    private static int executeBodyTemp(CommandContext<class_2168> ctx) {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 player = DebugCommands.getPlayerOrFeedback(src);
        if (player == null) {
            return 0;
        }
        double val = BodyTemperatureState.getC(player);
        double rate = BodyTemperatureAPI.computeRateCPerSecond((class_1657)player, val);
        src.method_9226(() -> class_2561.method_43470((String)("Body temperature: " + String.format("%.2f", val) + "\u00b0C (dT/dt: " + String.format("%.5f", rate) + " \u00b0C/s)")), false);
        return 1;
    }

    private static int executeBodySet(CommandContext<class_2168> ctx, String value) {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 player = DebugCommands.getPlayerOrFeedback(src);
        if (player == null) {
            return 0;
        }
        try {
            double v = Double.parseDouble(value);
            BodyTemperatureState.setC(player, v);
            src.method_9226(() -> class_2561.method_43470((String)("Set body temperature to " + String.format("%.2f", v) + "\u00b0C")), false);
            return 1;
        }
        catch (NumberFormatException e) {
            src.method_9213((class_2561)class_2561.method_43470((String)("Invalid number: " + value)));
            return 0;
        }
    }

    private static int executeSoaked(CommandContext<class_2168> ctx) {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 player = DebugCommands.getPlayerOrFeedback(src);
        if (player == null) {
            return 0;
        }
        boolean soaked = SoakedAPI.isSoaked((class_1657)player);
        double secs = soaked ? SoakedAPI.getSoakedSeconds((class_1657)player) : 0.0;
        String msg = soaked ? "Soaked (" + String.format("%.1f", secs) + "s remaining)" : "Dry";
        src.method_9226(() -> class_2561.method_43470((String)msg), false);
        return 1;
    }

    private static int executeBiome(CommandContext<class_2168> ctx) {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 player = DebugCommands.getPlayerOrFeedback(src);
        if (player == null) {
            return 0;
        }
        class_1937 world = player.method_37908();
        class_2338 pos = player.method_24515();
        class_6880 biomeEntry = world.method_23753(pos);
        String regId = biomeEntry.method_40230().map(k -> k.method_29177().toString()).orElse("unknown");
        String key = BiomeAPI.keyFor((class_6880<class_1959>)biomeEntry);
        Optional<BiomeAPI.CustomBiome> resolved = BiomeAPI.get(key);
        String configured = resolved.map(cb -> "Configured: temp=" + String.format("%.1f", cb.temperature) + "\u00b0C, humidity=" + cb.humidity + "%").orElse("Configured: none");
        String collapsed = key == null ? null : "biome." + regId.split(":")[0] + "." + regId.split(":")[1].replace('/', '.').replace(".", ".");
        int regCount = BiomeAPI.snapshotConfigured().size();
        int defCount = BiomeAPI.snapshotDefaults().size();
        String msg = "Biome id: " + regId + ", key: " + (key == null ? "unknown" : key) + ", " + configured + ", configuredEntries=" + regCount + ", defaultEntries=" + defCount;
        src.method_9226(() -> class_2561.method_43470((String)msg), false);
        return 1;
    }

    private static class_3222 getPlayerOrFeedback(class_2168 src) {
        try {
            return src.method_44023();
        }
        catch (Exception e) {
            src.method_9213((class_2561)class_2561.method_43470((String)"This command requires a player context."));
            return null;
        }
    }
}

