/*
 * Decompiled with CFR 0.152.
 */
package gavinx.temperatureapi.net;

import gavinx.temperatureapi.TemperatureApi;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.SplittableRandom;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public final class DiurnalSync {
    public static final class_2960 CHANNEL = new class_2960("temperatureapi", "diurnal_sync");
    private static final Map<class_2960, Long> lastSentDayByDim = new HashMap<class_2960, Long>();

    private DiurnalSync() {
    }

    public static void registerServer() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.field_14140;
            class_3218 world = (class_3218)player.method_37908();
            DiurnalSync.sendForWorldToPlayer(world, player);
        });
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            if (!(world instanceof class_3218)) {
                return;
            }
            class_3218 sw = world;
            long time = sw.method_8532();
            long dayIndex = Math.floorDiv(time, 24000L);
            class_2960 dim = sw.method_27983().method_29177();
            Long last = lastSentDayByDim.get(dim);
            if (last == null || last != dayIndex) {
                lastSentDayByDim.put(dim, dayIndex);
                for (class_3222 p : sw.method_18456()) {
                    DiurnalSync.sendForWorldToPlayer(sw, p);
                }
                TemperatureApi.LOGGER.debug("Synced diurnal params for {} day {} to {} players", new Object[]{dim, dayIndex, sw.method_18456().size()});
            }
        });
    }

    private static void sendForWorldToPlayer(class_3218 world, class_3222 player) {
        long time = world.method_8532();
        long dayIndex = Math.floorDiv(time, 24000L);
        DayNightParams params = DiurnalSync.computeParams(world, dayIndex);
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10814(world.method_27983().method_29177().toString());
        buf.writeLong(dayIndex);
        buf.writeDouble(params.M);
        buf.writeDouble(params.m);
        ServerPlayNetworking.send((class_3222)player, (class_2960)CHANNEL, (class_2540)buf);
    }

    private static DayNightParams computeParams(class_3218 world, long dayIndex) {
        long seed = DiurnalSync.seedFor(world, dayIndex);
        SplittableRandom rng = new SplittableRandom(seed);
        double M = rng.nextDouble(0.0, 6.0);
        double m = rng.nextDouble(-7.0, -2.0);
        return new DayNightParams(M, m);
    }

    private static long seedFor(class_3218 world, long dayIndex) {
        long seed = -7046029254386353131L;
        try {
            seed ^= DiurnalSync.mix64(world.method_8412());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String dim = world.method_27983().method_29177().toString();
        seed ^= DiurnalSync.mix64(dim.hashCode());
        return seed ^= DiurnalSync.mix64(dayIndex);
    }

    private static long mix64(long z) {
        z = (z ^ z >>> 30) * -4658895280553007687L;
        z = (z ^ z >>> 27) * -7723592293110705685L;
        return z ^ z >>> 31;
    }

    private record DayNightParams(double M, double m) {
    }
}

